const express = require('express');
const router = express.Router();
const PLog = require('plog');
const locs = require('../loc/subs.json');
const langSetup = require('./common/langSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const rumCounterSetup = require('./common/rumCounterSetup');
const checkAuth = require('./common/checkAuth');
const showPlus = require('./common/plusGuard').showPlus;
const createState = require('./common/createState');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

const enter = [
    apiSetup,
    checkAuth,
    getUatraitsData,
    langSetup,
    getYaExperimentsFlags,
    function checkExp(req, res, next) {
        const experiments = (res.locals.experiments && res.locals.experiments.flags) || [];

        if (experiments.includes('passport-subs-eula-check-on')) {
            return next();
        }

        return req._controller.redirectToFrontpage();
    },
    function getTrack(req, res, next) {
        req.api
            .getTrack({}, true)
            .then(function(result) {
                res.locals.track_id = result.body.track_id;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('service_subs, getTrack')
                    .write(error);
                return next();
            });
    },
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    createState,
    writeStatbox({
        action: 'opened',
        mode: 'service_subs'
    }),
    function getSubs(req, res, next) {
        req.api
            .getUserSubs()
            .then((result = {}) => {
                const {body = {}} = result;
                const {services = {}} = body;

                res.locals.subs = returnSubsList(services, res.locals.language);

                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('service_subs, getSubs')
                    .write(error);
                return next();
            });
    },
    function updateState(req, res, next) {
        const {store = {}} = res.locals;
        const list = [...(res.locals.subs || [])];
        const actualList = [...list].filter((item) => item.emailSentTs > 0 && item.isSubscribed);

        store.subs = {
            list,
            error: null,
            hasChanged: false,
            hasAllChecked: list.every((item) => item.isSubscribed),
            hasAllActualChecked: actualList.every((item) => item.isSubscribed),
            hasAllUnchecked: list.every((item) => !item.isSubscribed),
            hasAllActualUnchecked: actualList.every((item) => !item.isSubscribed),
            actualList: actualList,
            listType: 'actual',
            wasListLoad: true
        };

        store.metrics = {
            header: 'Страница настройки рассылок'
        };
        store.monitoring = {
            page: 'profile.subs'
        };

        return next();
    },
    rumCounterSetup,
    function(req, res) {
        const lang = res.locals.language;

        res.render(`react.subs.${lang}.jsx`);
    }
];

const sendData = [
    apiSetup,
    checkAuth,
    function preparedStat(req, res, next) {
        res.locals.preparedStat = {
            services: req.body.services
        };

        return next();
    },
    writeStatbox({
        action: 'write_statbox',
        mode: 'service_subs'
    }),
    function(req, res) {
        return req.api
            .changeUserSubs({subscriptions_json: req.body.services})
            .then((response = {}) => {
                if (response.body && response.body.status === 'ok') {
                    return res.json({status: 'ok'});
                }

                return res.json({status: 'error', error: ['internal']});
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('service_subs, sendData')
                    .write(error);
                return res.json({status: 'error', error: ['internal']});
            });
    }
];

const getSubsList = [
    apiSetup,
    function(req, res) {
        req.api
            .getUserSubs()
            .then((result = {}) => {
                const {body = {}} = result;
                const {services = {}} = body;

                return res.json({
                    status: 'ok',
                    list: returnSubsList(services, res.locals.language)
                });
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('service_subs, getSubsList')
                    .write(error);
                return res.json({status: 'error', error: ['internal']});
            });
    }
];

function returnSubsList(services = {}, lang = 'ru') {
    if (Object.entries(services).length) {
        const servicesList = Object.entries(services).map((item) => {
            const {slug} = item[1] || {};
            const locNames = locs[lang] && locs[lang].ProfileSubs;

            if (slug && locNames[slug]) {
                return {...item[1], id: item[0], name: locNames[slug]};
            }

            return null;
        });
        const cleanList = servicesList.filter((item) => item !== null);
        const namesList = cleanList.map((item) => item.name).sort();

        return namesList.map((item) => {
            const actualItem = cleanList.find((sub) => sub.name === item);

            return {
                isSubscribed: actualItem.is_subscribed,
                slug: actualItem.slug,
                id: actualItem.id,
                name: item,
                emailSentTs: actualItem.email_sent_ts,
                hasChanged: false
            };
        });
    }

    return [];
}

router.get('/', enter);

exports.router = router;
exports.sendSubs = sendData;
exports.getSubsList = getSubsList;
