const url = require('url');
const _ = require('lodash');
const express = require('express');
const PLog = require('plog');
const apiSetup = require('./common/apiSetup');
const config = require('../configs/current');
const router = express.Router();
const locs = require('../loc/frontend.json');
const langs = config.langs;
const langSetup = [
    function(req, res, next) {
        req._controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                PLog.warn()
                    .logId(req.logID)
                    .type('subscribe')
                    .write(err);
            })
            .done(function() {
                return next();
            });
    },
    function(req, res, next) {
        const language = langs[langs.indexOf(res.locals.language)] || 'ru';

        res.loc = locs[language].Frontend;

        if (req.api) {
            req.api.language(language);
        }

        next();
    }
];

router.get('/', [
    function(req, res, next) {
        const mode = req.query.mode;

        if (mode === 'subscribe') {
            next();
        } else {
            next('route');
        }
    },
    apiSetup,
    langSetup,
    function subscribe(req, res, next) {
        const query = req.query;
        const service = query.from;
        const defaultRetpath = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: 'profile'
        });
        const retpath = query.retpath || defaultRetpath;

        res.locals.defaultRetpath = defaultRetpath;

        if (!service) {
            res.redirect(defaultRetpath);
        }

        req.api
            .subscribe({retpath, service})
            .then(function(response) {
                const body = response && response.body;

                if (!body) {
                    next('error');
                } else if (body.status === 'ok') {
                    res.redirect(retpath);
                }
            })
            .catch(function(error) {
                next(error);
            });
    },
    // eslint-disable-next-line no-unused-vars
    function handleError(err, req, res, next) {
        if (err instanceof Array) {
            const retpath = url.format(req._controller.getUrl());

            if (err.includes('sessionid.invalid')) {
                res.redirect(
                    url.format(
                        _.extend({}, req._controller.getAuthUrl(), {
                            query: {
                                retpath
                            }
                        })
                    )
                );
            } else if (err.includes('account.without_login')) {
                res.redirect(
                    url.format(
                        _.extend({}, req._controller.getProfileUpgradeUrl(), {
                            query: {
                                origin: 'passport_profile',
                                retpath
                            }
                        })
                    )
                );
            } else if (err.includes('account.without_password')) {
                res.redirect(
                    url.format(
                        _.extend({}, req._controller.getProfileUpgradeUrl(), {
                            query: {
                                origin: 'passport_profile',
                                retpath
                            }
                        })
                    )
                );
            } else {
                req._controller.followRetpath();
            }
        } else {
            req._controller.followRetpath();
        }
    }
]);

exports.router = router;
