var countries = require('../lib/geo/countries');
var cities = require('../lib/geo/cities');
var _ = require('lodash');

exports.route = function(app) {
    app.post('/suggest/country', this.country).post('/suggest/city', this.city);
};

exports.country = function(req, res) {
    var str = req.body.str;
    var lang = req.body.language || 'ru';
    var limit = req.body.limit || 10;

    var result = [];
    var _countries = countries[lang] || countries.en || [];

    if (str && _countries.length) {
        var strRegExp = new RegExp(`^${str.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')}`, 'i');

        result = _.filter(_countries, function(item) {
            return (item.name && item.name.match(strRegExp)) || (item.ename && item.ename.match(strRegExp));
        });

        result = result.slice(0, limit);
    }

    res.send(result);
};

exports.city = function(req, res) {
    var str = req.body.str;
    var lang = req.body.language || 'ru';
    var limit = req.body.limit || 10;
    var countryId = req.body.country_id || null;
    var countryName = req.body.country_name || null;

    var result = [];
    var _cities = cities[lang] || cities.en || [];

    if (countryId) {
        var id = parseInt(countryId, 10);

        _cities = _.filter(_cities, function(item) {
            return item.countryId === id;
        });
    }

    if (!countryId && countryName && _cities.length) {
        var countryRegExp = new RegExp(`^${countryName.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')}`, 'i');

        _cities = _.filter(_cities, function(item) {
            return (
                (item.countryName && item.countryName.match(countryRegExp)) ||
                (item.countryEname && item.countryEname.match(countryRegExp))
            );
        });
    }

    if (str && _cities.length) {
        var strRegExp = new RegExp(`^${str.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')}`, 'i');

        result = _.filter(_cities, function(item) {
            return (item.name && item.name.match(strRegExp)) || (item.ename && item.ename.match(strRegExp));
        });

        result = result.slice(0, limit);
    }

    res.send(result);
};
