const express = require('express');
const router = express.Router();
const apiSetup = require('../common/apiSetup');
const setCORSHeaders = require('../common/setCORSHeaders.js');
const writeStatbox = require('../common/writeStatbox');

const {Validator} = require('express-json-validator-middleware');
const querySchema = require('./query.schema.json');
const bodySchema = require('./body.schema.json');

const validator = new Validator({allErrors: true}); // Pass in options to the Ajv instance
const {validate} = validator;

const optionsRoute = [
    setCORSHeaders,
    function(req, res) {
        return res.end();
    },
    errorsHandler
];

const postRoute = [
    setCORSHeaders,
    validate({
        query: querySchema,
        body: bodySchema
    }),
    apiSetup,
    writeStatbox({
        action: 'opened',
        mode: 'support_code_create'
    }),
    (req, res) => {
        req.api
            .supportCodeCreate(req.body) // Провалидировали схемой, поэтому не страшно
            .then((result) => res.json(result.body))
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    },
    errorsHandler
];

// eslint-disable-next-line no-unused-vars
function errorsHandler(err, req, res, next) {
    if (err.name === 'JsonSchemaValidationError') {
        return res.status(400).json({
            status: 'error',
            code: 'invalid params'
        });
    }

    return res.status(500).json({
        status: 'error',
        code: 'internal'
    });
}

router.post('/', postRoute);
router.options('/', optionsRoute);

exports.router = router;
