const express = require('express');
const router = express.Router();
const PLog = require('plog');
const langSetup = require('./common/langSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const apiSetup = require('./common/apiSetup');
const validateCSRF = require('./common/validateCSRF.js');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const checkAuth = require('./common/checkAuth');
const showPlus = require('./common/plusGuard').showPlus;
const createState = require('./takeout/createTakeoutState');
const renderPage = require('./takeout/renderPage');
const getTakeoutInfo = require('./takeout/getTakeoutInfo');
const getArchiveUrl = require('./takeout/getArchiveUrl');
const startTakeoutRequest = require('./takeout/startTakeoutRequest');
const getArchivePassword = require('./takeout/getArchivePassword');
const checkUserAttributes = require('./takeout/checkUserAttributes');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const getMetrics = require('./common/getMetrics');
const rumCounterSetup = require('./common/rumCounterSetup');

const enter = [
    apiSetup,
    checkAuth,
    getUatraitsData,
    langSetup,
    getYaExperimentsFlags,
    function getTrack(req, res, next) {
        req.api
            .getTrack({}, true)
            .then(function(result) {
                res.locals.track_id = result.body.track_id;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('takeout, getTrack')
                    .write(error);
                return next();
            });
    },
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    createState,
    checkUserAttributes,
    function checkIfTakeoutAvailable(req, res, next) {
        const isTakeOutAvailable = res.locals.isTakeOutAvailable;
        const isYandexoid = res.locals.isYandexoid;

        if (isYandexoid || isTakeOutAvailable) {
            return next();
        }

        if (req._controller.getEnv() === 'testing' || req._controller.getEnv() === 'development') {
            return next();
        }

        return req._controller.redirectToFrontpage();
    },
    (req, res, next) => (res.locals.store.common.isSocialchik ? next() : getTakeoutInfo(req, res, next)),
    writeStatbox({
        action: 'opened',
        mode: 'takeout'
    }),
    getMetrics({header: 'Архив пользовательских данных'}),
    rumCounterSetup,
    renderPage
];

const startTakeoutProcess = [apiSetup, validateCSRF, startTakeoutRequest];

const getArchiveData = [apiSetup, validateCSRF, getArchiveUrl];

const getPassword = [apiSetup, validateCSRF, getArchivePassword];

router.get('/', enter);

exports.router = router;

exports.takeOutHandles = {
    startTakeoutProcess,
    getArchiveData,
    getPassword
};
