const PLog = require('plog');

module.exports = function checkUserAttributes(req, res, next) {
    req._controller
        .getAuth()
        .sessionID({
            attributes: '1005,184', // social, takeoutAllowed,
            aliases: '13' // is_yandexoid
        })
        .then((response = {}) => {
            const {attributes, aliases} = response;

            res.locals.isTakeOutAvailable = Boolean(attributes && attributes['184']);
            res.locals.isYandexoid = Boolean(aliases && aliases['13']);

            if (res.locals.store) {
                res.locals.store.common.isSocialchik = response.auth && !response.auth.have_password;
            }

            return next();
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('takeout, checkIfSocial')
                .write(error);
            return next();
        });
};
