const url = require('url');
const config = require('../../configs/current');
const PLog = require('plog');
const LangSwitcherView = require('../../blocks/layout/LangSwitcherView');
const isIntranet = process.env.INTRANET === 'intranet';

module.exports = function createState(req, res, next) {
    const langSwitcher = new LangSwitcherView(req._controller);
    const locals = res.locals;
    const tld = req._controller.getTld();
    const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const {paths = {}, version} = config;
    const {static: staticPath} = paths;
    const {userType = {}, account = {}} = locals;
    const {metricsUserType} = userType;
    const {accounts = [], defaultAccount = {}} = locals.accounts;
    const {blackbox: {connection_id: ci = ''} = {}} = req;

    let queryUid = '';

    if (req.query && req.query.uid) {
        queryUid = req.query.uid.replace(/[^0-9]/g, '');
    }

    locals.store = {
        settings: {
            host: url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname
            }),
            avatar: config.paths.avatar || {},
            embeddedauth: config.paths.embeddedauth || '',
            soundManagerPath: config.paths.soundManager,
            links: isIntranet ? config.links.intranet : config.links[tld] || config.links.ru || {},
            help: config.paths.help || {},
            tld,
            language: locals.language,
            ua: locals.ua || {},
            env: {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            },
            accountsUrl: config.paths.accountsUrl,
            version,
            metricsUserType,
            staticPath
        },
        common: {
            uid: queryUid || defaultAccount.uid,
            login: defaultAccount.login,
            yandexuid,
            track_id: locals.track_id,
            experiments: res.locals.experiments,
            retpath: url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: '/profile'
            }),
            currentPage: req._controller.getUrl().href,
            defaultPage: url.format({
                pathname: '/profile/getdata',
                query: req.query
            }),
            isPDD: account.domain !== undefined,
            actionForRepeat: null
        },
        domik: {
            errors: {},
            requestPassword: false,
            requestCaptcha: false,
            passwordNotMatched: false,
            captchaNotMatched: false,
            loading: false
        },
        access: {
            is2faEnabled: account.is_2fa_enabled
        },
        takeOutInfo: {
            status: 'isNotRequested',
            isLoading: false,
            isPasswordVisible: false,
            hasPasswordCopied: false
        },
        header: {
            accounts: accounts,
            defaultAccount: defaultAccount || {},
            canAddMore: locals.accounts['can-add-more'],
            ci
        },
        captcha: {
            loading: false,
            loadingAudio: false,
            playing: false,
            type: 'text',
            key: null,
            imageUrl: null,
            introSound: null,
            captchaSound: null
        },
        dashboard: {
            plus: Object.assign(
                {},
                {
                    country: locals.country,
                    allowed: locals.showPlus,
                    enabled: false
                },
                defaultAccount.plus
            )
        },
        footer: {
            langlist: []
        },
        metrics: {
            header: 'Страница выгрузки данных'
        },
        monitoring: {
            page: 'profile.getdata'
        }
    };

    langSwitcher
        ._compile()
        .then(function(response = {}) {
            const {langlist = {}} = response;

            locals.store.footer.langlist = langlist;
        })
        .catch(function(error) {
            PLog.warn()
                .logId(req.logID)
                .type('profile.getdata, langSwitcher')
                .write(error);
        })
        .done(function() {
            delete locals.account;
            delete locals.accounts;
            return next();
        });
};
