const PLog = require('plog');

module.exports = function getArchivePassword(req, res, next) {
    if (!req.body.uid) {
        return res.json({status: 'error', error: ['uid.empty']});
    }

    req.api
        .getArchivePassword(req.body.uid)
        .then((response) => {
            const {body} = response;

            if (body.status === 'ok' && body.archive_password) {
                return res.json({status: 'ok', password: body.archive_password});
            }

            return next();
        })
        .catch((error) => {
            res.json({status: 'error', errors: error});

            PLog.warn()
                .logId(req.logID)
                .type('takeout, getArchivePassword')
                .write(error);
            return next();
        });
};
