const PLog = require('plog');

module.exports = function getArchiveUrl(req, res, next) {
    const uid = req.body.uid;

    if (!uid) {
        PLog.warn()
            .logId(req.logID)
            .type('takeout, getArchiveUrl')
            .write('no uid provided from client');
        return res.json({status: 'error', error: ['uid.empty']});
    }

    req.api
        .getArchiveUrl(uid)
        .then((response) => {
            const {body} = response;

            if (body.status === 'ok' && body.archive_url) {
                res.json({status: 'ok', archiveUrl: body.archive_url});

                PLog.info()
                    .logId(req.logID)
                    .type('takeout success, getArchiveUrl')
                    .write('state takeout archiveUrl', body.archive_url);
            }
            return next();
        })
        .catch((error) => {
            res.json({status: 'error', errors: error});

            PLog.warn()
                .logId(req.logID)
                .type('takeout error, getArchiveUrl')
                .write(error);

            return next();
        });
};
