const PLog = require('plog');
const url = require('url');

module.exports = function getTakeoutInfo(req, res, next) {
    const state = res.locals.store;
    const uid = state.common && state.common.uid;

    return req.api
        .getTakeoutStatus(uid)
        .then((response) => {
            const {body} = response;

            if (body.is_extract_in_progress) {
                state.takeOutInfo = {
                    status: 'isBeingRequesting'
                };
            }

            if (body.archive) {
                const {archive} = body;
                const archiveInfo = {
                    created: formatDate(archive.created_at),
                    valid: formatDate(archive.valid_until),
                    isPasswordRequired: archive.has_password
                };

                state.takeOutInfo = {
                    status: 'isReady',
                    archiveInfo
                };
            }
            PLog.info()
                .logId(req.logID)
                .type('takeout success, getTakeoutStatus')
                .write('state takeout status is ', state.takeOutInfo.status);
            return next();
        })
        .catch((error) => {
            const errorCode = Array.isArray(error) ? error[0] : 'exception.unhandled';
            const isProblemAccount = ['account.not_found', 'account.disabled'].includes(errorCode);

            if (isProblemAccount) {
                req._controller.redirectToAuth();
            }

            if (errorCode === 'sessionid.no_uid') {
                const retpath = url.format(req._controller.getUrl());

                req._controller.redirectToAuthWithUid(uid, retpath);
            }

            PLog.warn()
                .logId(req.logID)
                .type('takeout, getTakeoutStatus')
                .write(error);
            return next();
        });
};

function formatDate(timeInSec) {
    const dateInMs = new Date(timeInSec * 1000);
    const monthNum = dateInMs.getMonth() + 1;
    const dateNum = dateInMs.getDate();
    const monthFormatted = monthNum > 9 ? monthNum : `0${monthNum}`;
    const dateFormatted = dateNum > 9 ? dateNum : `0${dateNum}`;

    return `${dateFormatted}.${monthFormatted}.${dateInMs.getFullYear()}`;
}
