const PLog = require('plog');

module.exports = function startTakeoutRequest(req, res, next) {
    req.api
        .startTakeoutRequest(req.body.uid)
        .then((response) => {
            const {body} = response;

            if (body.status === 'ok') {
                res.json({status: 'ok'});
            }

            return next();
        })
        .catch((errors) => {
            res.json({status: 'error', errors});
            PLog.warn()
                .logId(req.logID)
                .type('takeout, startTakeoutRequest')
                .write(errors);

            return next();
        });
};
