const PLog = require('plog');
const apiSetup = require('../../common/apiSetup');
const {urlFormat} = require('../../common/urlFormat');
const {getFirstSymbolForRetpathQuery} = require('../../common/getFirstSymbolForRetpathQuery');
const validateCSRF = require('../../common/validateCSRF.js');
// PASSP-38301 skip refunds
// const TrustPaymentsApi = require('../../../lib/api/trustPayments');

// const createTrustPaymentsApi = (req) => new TrustPaymentsApi(req.logID, req._controller.getAuth().getUid());

const errorCb = ({req, res, error = {}, type}) => {
    PLog.warn()
        .logId(req.logID)
        .type(type)
        .write(error);

    return res.json({
        status: 'error',
        errors: error || []
    });
};

const getRetpathFor3ds = (req, res, isError) => {
    const trackId = req.query && req.query.track_id;
    const defaultRetpath = urlFormat({
        hostname: req.hostname,
        pathname: '/profile'
    });

    req.api
        .readTrack(trackId)
        .then((result) => {
            const {
                body: {retpath = defaultRetpath}
            } = result;

            const finalPathWithError = `${retpath}${getFirstSymbolForRetpathQuery(retpath)}status=error`;

            return res.json({
                retpath: isError ? finalPathWithError : retpath
            });
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('user-validate, getRetpathFor3ds')
                .write(error);
            return res.json({
                retpath: `${defaultRetpath}?status=error`
            });
        });
};

const getRetpath3ds = [
    apiSetup,
    validateCSRF,
    function(req, res) {
        const {body: {isErrorRetpath = false} = {}} = req;

        return getRetpathFor3ds(req, res, isErrorRetpath);
    }
];

const submit3ds = [
    apiSetup,
    validateCSRF,
    function submit3dsVerify(req, res, next) {
        const trackId = req.query && req.query.track_id;
        const {body: {useMobileLayout} = {}} = req;

        return req.api
            .challenge3dsVerifySubmit({trackId, isNew3dsForm: true, useMobileLayout})
            .then((result) => {
                const {
                    body: {status}
                } = result;

                if (status === 'ok') {
                    return next();
                }
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, submit3dsVerify'}));
    },
    function commit3dsVerify(req, res, next) {
        const trackId = req.query && req.query.track_id;

        return req.api
            .challenge3dsVerifyCommit({track_id: trackId})
            .then((result) => {
                const {
                    body: {status, url_3ds: url3ds, errors}
                } = result;

                if (status === 'ok') {
                    return next();
                }

                if (status === 'error' && Array.isArray(errors) && errors[0] === '3ds.not_passed') {
                    return res.json({
                        status: 'ok',
                        url3ds
                    });
                }

                throw errors;
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, commit3dsVerify'}));
    },
    function validateCommit(req, res, next) {
        const trackId = req.query && req.query.track_id;
        const challengeType = '3ds';

        req.api
            .userValidateCommit({track_id: trackId, challenge: challengeType})
            .then(function(response = {}) {
                const {body: {status} = {}} = response;

                if (status === 'ok') {
                    return next();
                }
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, validateCommit'}));
    },
    function validateSave(req, res) {
        const trackId = req.query && req.query.track_id;

        req.api
            .userValidateSave({track_id: trackId})
            .then((response = {}) => {
                const {body: {status} = {}} = response;

                if (status === 'ok') {
                    return res.json({
                        status: 'ok'
                    });
                }
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, validateSave'}));
    }
];

const commit3ds = [
    apiSetup,
    validateCSRF,
    function commit3dsVerify(req, res, next) {
        const trackId = req.query && req.query.track_id;
        const errorsToRetry = ['3ds.not_passed'];

        return req.api
            .challenge3dsVerifyCommit({track_id: trackId, errorsToRetry})
            .then((result) => {
                const {body: {status, errors} = {}} = result;

                if (status === 'ok') {
                    return next();
                }

                throw errors;
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, commit3ds'}));
    },
    // PASSP-38301 skip refunds
    //
    // function getRefunds3ds(req, res, next) {
    //     const trustPaymentsApi = createTrustPaymentsApi(req);
    //     const {body: {purchaseToken} = {}} = req;
    //     const AMOUNT_3DS = '11';

    //     trustPaymentsApi
    //         .getRefunds({purchaseToken, amount: AMOUNT_3DS, reason: '3ds challenge refund'})
    //         .then((result) => {
    //             const {body: {status, trust_refund_id, errors} = {}} = result;

    //             if (status === 'success' && trust_refund_id) {
    //                 trustPaymentsApi.startRefunds({refundId: trust_refund_id}).always(() => {
    //                     return next();
    //                 });
    //             }

    //             throw errors;
    //         })
    //         .catch((error) => {
    //             PLog.warn()
    //                 .logId(req.logID)
    //                 .type('user-validate, getRefunds3ds')
    //                 .write(error);

    //             return next();
    //         });
    // },
    function validateCommit(req, res, next) {
        const trackId = req.query && req.query.track_id;
        const challengeType = '3ds';

        req.api
            .userValidateCommit({track_id: trackId, challenge: challengeType})
            .then(function(response = {}) {
                const {body: {status} = {}} = response;

                if (status === 'ok') {
                    return next();
                }
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, validateCommit'}));
    },
    function validateSave(req, res) {
        const trackId = req.query && req.query.track_id;

        req.api
            .userValidateSave({track_id: trackId})
            .then((response = {}) => {
                const {body: {status} = {}} = response;

                if (status === 'ok') {
                    return res.json({
                        status: 'ok'
                    });
                }
            })
            .catch((error) => errorCb({req, res, error, type: 'user-validate, validateSave'}));
    }
];

exports.commit3ds = commit3ds;
exports.submit3ds = submit3ds;
exports.getRetpath3ds = getRetpath3ds;
