'use strict';

// TODO: Обработка ошибок

var apiSetup = require('./common/apiSetup');
const checkAuth = require('./common/checkAuth');
const {expFilter} = require('./common/expFilter');
var url = require('url');
var _ = require('lodash');
var config = require('../configs/current');
var langs = config.langs;
var processErrors = require('../lib/passport-errors').processErrors;
var util = require('util');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

var getControls = (function() {
    var controls = {};

    return function(lang) {
        lang = langs[langs.indexOf(lang)] || 'ru';

        if (lang in controls) {
            return _.clone(controls[lang], true);
        }

        controls[lang] = require(`../lib/passport-form/template.${lang}.js`);
        return getControls(lang);
    };
})();

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.get('/profile/access/apppaswords/new/', mutateRetpath, routes.enter);
    app.post('/profile/access/apppaswords/new/', routes.save);
    app.get('/auth/verify/?', [expFilter({exclude: 'new-auth-verify-design'}), routes.enter]);
    app.post('/auth/verify/?', routes.save);
};

function mutateRetpath(req, res, next) {
    var request = _.extend({}, req.nquery, req.body);
    var query = _.pick(request, ['retpath', 'scope']);

    if (query.scope === 'mail') {
        req.body.retpath = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: '/profile/access/',
            hash: '#open_popup_mail',
            query: {
                retpath: query.retpath
            }
        });
    }

    return next();
}

function langSetup(req, res, next) {
    req._controller
        .getLanguage()
        .then(function(lang) {
            res.locals.language = lang;
        })
        .catch(function(err) {
            res.locals.language = 'ru';

            require('plog')
                .warn()
                .logId(req.logID)
                .type('confirm langSetup')
                .write(err);
        })
        .done(function() {
            return next();
        });
}

exports.routes.enter = [
    apiSetup,
    checkAuth,
    langSetup,
    getTrack,
    doSubmit,
    enableCaptcha,
    getYaExperimentsFlags,
    renderPage,
    function(error, req, res, next) {
        require('plog')
            .warn()
            .logId(req.logID)
            .type('confirm error handler')
            .write(error);

        return next(error);
    },
    errorHandler,
    enableCaptcha,
    // defaultProcess,
    renderPage
];

exports.routes.save = [
    apiSetup,
    checkCaptcha,
    doCommit,
    function(error, req, res, next) {
        var controller = req._controller;
        // return langSetup.apply(null, [req, res, next]);

        controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                require('plog')
                    .warn()
                    .logId(req.logID)
                    .type('confirm error handler')
                    .write(err);
            })
            .done(function() {
                return next(error);
            });
    },
    errorHandler,
    enableCaptcha,
    defaultProcess,
    renderPage
];

function getTrack(req, res, next) {
    var track_id = req.body.track_id || (req.nquery && req.nquery.track_id);
    var uid = req.body.uid || (req.nquery && req.nquery.uid);

    if (track_id) {
        req.api.track(track_id);
        return next();
    } else {
        req.api.initTrack({uid}).then(function(result) {
            req.api.track(result.body.track_id);
            return next();
        }, next);
    }
}

function doSubmit(req, res, next) {
    var request = _.extend({}, req.nquery, req.body);
    var query = _.pick(request, ['retpath', 'origin']);
    var data = res.data || (res.data = {});
    var api = req.api;

    query['track_id'] = req.api.track();
    data['do_not_show_login_field'] = '1';
    data['track_id'] = req.api.track();

    api.passwordConfirmSubmit(query).done(function(result) {
        var data = res.data || (res.data = {});

        result = result.body;

        data['do_not_show_login_field'] = '1';
        data['track_id'] = result.track_id;
        data['csrf_token'] = result.csrf_token;

        if (result.account && (result.account.display_login || result.account.display_name)) {
            data['display_name'] = result.account.display_login || result.account.display_name.name;
        }

        if (result.account && result.account.display_login) {
            data['display_login'] = result.account.display_login;
        }

        if (result.status === 'ok') {
            return next();
        } else {
            return next(result.errors);
        }
    }, next);
}

function doCommit(req, res, next) {
    var api = req.api;
    const controller = req._controller;

    api.passwordConfirmCommit({
        track_id: req.body.track_id,
        password: req.body.passwd
    })
        .then(function(result) {
            if (result.body.status !== 'ok') {
                res.account = result.body && result.body.account;
                return Promise.reject(result.body && result.body.errors);
            }
            return result;
        })
        .then((result) => {
            const body = result.body;

            if (body.state) {
                return res.redirect(
                    url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: 'auth',
                        query: {
                            track_id: body.track_id,
                            retpath: body.retpath
                        }
                    })
                );
            }

            return result;
        })
        .then(function(commitResult) {
            return api.bundleSession({
                track_id: commitResult.track_id,
                retpath: req.body.retpath
            });
        })
        .then(function(bundleSessionResult) {
            var body = bundleSessionResult.body;

            controller.augmentResponse(body);

            if (body.cookies) {
                var pathname = '/auth/finish/';

                return res.redirect(
                    url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname,
                        query: {
                            track_id: body.track_id,
                            retpath: body.retpath
                        }
                    })
                );
            } else {
                if (body.retpath) {
                    return res.redirect(body.retpath);
                } else {
                    return res.redirect(
                        url.format({
                            protocol: req.headers['x-real-scheme'],
                            hostname: req.hostname,
                            pathname: 'profile'
                        })
                    );
                }
            }
        })
        .catch(next);
}

function errorHandler(err, req, res, next) {
    /* jshint unused:false */

    var lang = res.locals.language;
    var request = _.extend({}, req.nquery, req.body);
    var query = _.pick(request, ['retpath', 'origin']);

    var data = res.data || (res.data = {});

    if (util.isArray(err) && _.intersection(err, ['action.not_required', 'account.auth_passed']).length > 0) {
        return res.redirect(
            url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'redirect',
                query: {
                    retpath: query.retpath
                }
            })
        );
    }

    if (
        util.isArray(err) &&
        _.intersection(err, [
            'account.disabled',
            'account.not_found',
            'account.disabled_on_deletion',
            'sessionid.invalid'
        ]).length > 0
    ) {
        return res.redirect(
            url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'auth',
                query
            })
        );
    }

    if (util.isArray(err) && _.intersection(err, ['account.without_password']).length > 0) {
        return res.redirect(
            url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'profile/upgrade',
                query: {
                    origin: query.origin || 'passport_profile',
                    retpath: query.retpath
                }
            })
        );
    }

    if (util.isArray(err) && err.indexOf('captcha.required') !== -1) {
        req.captcha_required = true;
    }

    if (util.isArray(err) && err.indexOf('password.not_matched') !== -1 && res.account && res.account.is_2fa_enabled) {
        err[err.indexOf('password.not_matched')] = 'password.not_matched.2fa';
    }

    data.errors = processErrors(err, lang, {});
    data.display_login = data.display_login || req.body.display_login;
    data.display_name = data.display_name || req.body.display_login;
    data.do_not_show_login_field = '1';
    data.track_id = data.track_id || req.body.track_id;
    data.csrf_token = data.csrf_token || req.body.csrf_token;

    data.rawErrors = err;

    return next();
}

function renderPage(req, res) {
    var lang = res.locals.language;
    var data = res.data;

    data.static = config.paths.static;

    data.magic = {
        options: {
            handle: '/auth/verify/magic/status/'
        }
    };

    return res.render(`auth.verify.${lang}.js`, data);
}

function getConfig() {
    return config;
}

function enableCaptcha(req, res, next) {
    var data = res.data || (res.data = {});

    var captchaOpts = {
        asyncCheck: true,
        popup: true
    };
    var controls = getControls(res.locals.language);

    data.form = {
        control: _.filter(controls, function(cntrl) {
            return ['captcha', 'key'].indexOf(cntrl.id) !== -1;
        })
    };

    var captchaField = _.find(data.form.control, function(cntrl) {
        return cntrl.id === 'captcha';
    });

    if (captchaField) {
        var enableAudioCaptcha = true;

        data.form.control.forEach(function(cntrl) {
            if (cntrl.id === 'captcha') {
                cntrl.countryFromAudioWhiteList = enableAudioCaptcha;
            }
        });

        captchaField.options = captchaOpts;
    }

    if (req.captcha_required) {
        data.captchaRequired = true;
        return next();

        // var getCaptcha = req.api.captchaGenerate;
        // if (req.body.captcha_mode === 'audio') {
        // getCaptcha = req.api.audioCaptchaGenerate;
        // }
        // when.reduce([getCaptcha.call(req.api, captchaOpts)], reduceAnswer, {}).then(function(results) {
        // if (results.captcha) {
        // results.captcha.mode = req.body.captcha_mode === 'audio' ? 'audio' : 'text';
        // data.captcha = results.captcha;
        // }

        // next();
        // }, function(error) {
        // next(error);
        // });
    } else {
        data.form.control = _.filter(data.form.control, function(cntrl) {
            return !(cntrl.id === 'captcha' || cntrl.id === 'key');
        });
        next();
    }
}

function checkCaptcha(req, res, next) {
    var body = req.body;

    if (body.key && body.answer) {
        req.captcha_required = true;
        req.api
            .captchaCheck({
                key: body.key,
                answer: body.answer
            })
            .then(
                function(result) {
                    if (result.body.correct) {
                        req.captcha_required = false;
                        next();
                    } else {
                        next(['captcha.required', 'captcha.incorrect']);
                    }
                },
                function() {
                    next(['captcha.required', 'captcha.captchalocate']);
                }
            );
    } else {
        next();
    }
}

function defaultProcess(req, res, next) {
    var data = res.data || (res.data = {});
    var aliases = {
        login: {
            name: 'login'
        },
        hint_question_id: {
            name: 'question_id',
            missingvalue: 'invalid'
        },
        hint_question: {
            name: 'question',
            missingvalue: 'empty',
            process(data, control) {
                var question_id;

                if (!control.value) {
                    return;
                }

                if (data.form && data.form.control) {
                    question_id = _.filter(data.form.control, {id: 'question'})[0];

                    if (question_id) {
                        question_id.value = '99';
                    }
                }
            }
        },
        hint_answer: {
            name: 'answer',
            missingvalue: 'empty'
        },
        password: {
            name: 'password',
            prohibitedsymbols: 'invalid',
            tooshort: 'short',
            toolong: 'long',
            missingvalue: 'empty',
            likeoldpassword: 'equals_previous',
            foundinhistory: 'found_in_history'
        },
        firstname: {
            name: 'firstname',
            missingvalue: 'empty'
        },
        lastname: {
            name: 'lastname',
            missingvalue: 'empty'
        },
        captcha: {
            name: 'captcha'
        },
        answer: {
            name: 'captcha'
        },
        phone_number: {
            name: 'phone',
            needsconfirmation: 'required'
        },
        birthday: {
            name: 'birthday',
            process(data) {
                var value = data.fields && data.fields.birthday;
                var splitted;

                if (!value) {
                    return;
                }

                splitted = value.split('-');
                data.byear = splitted[0];
                data.bmonth = splitted[1];
                data.bday = splitted[2];
            }
        },
        'restore-method': {
            name: 'restore-method',
            process(data, control) {
                var validation_method = data.fields && data.fields.validation_method;

                control.state = validation_method === 'captcha' ? 'question' : 'phone';
            }
        }
    };

    function load() {
        if (data.rawErrors || data.fields) {
            if (data.form && data.form.control) {
                _.forEach(data.form.control, function(control) {
                    var alias = aliases[control.name];
                    var controlName = (alias && alias['name']) || control.name;

                    // Ошибки
                    if (data.rawErrors) {
                        _.forEach(control.error, function(error) {
                            var errorCode = (alias && alias[error.code]) || error.code;

                            error.active = false;

                            _.forEach(data.rawErrors, function(code) {
                                if (code.match('phone_secure')) {
                                    code = code.replace('phone_secure', 'phone');
                                }

                                if (code === util.format('%s.%s', controlName, errorCode)) {
                                    error.active = true;
                                }
                            });
                        });
                    }

                    // Предзаполненные
                    if (data.fields) {
                        if (controlName && data.fields[controlName]) {
                            control.value = data.fields[controlName];
                        }

                        if (alias && alias['process']) {
                            alias['process'](data, control);
                        }
                    }
                });
            }
        }

        return next();
    }

    load();
}

exports.getConfig = getConfig;
exports.doSubmit = doSubmit;
exports.errorHandler = errorHandler;
