const {
    webauthnList,
    webauthnRemove,
    webauthnRegSubmit,
    webauthnRegCommit,
    webauthnAuthSubmit,
    webauthnAuthCommit
} = require('./api');
const {WebauthnPage} = require('./page');
const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF.js');

exports.route = (app) => {
    app.post('/auth/webauthn/list', [validateCSRF, apiSetup, webauthnList]);
    app.post('/auth/webauthn/remove', [validateCSRF, apiSetup, webauthnRemove]);
    app.post('/auth/webauthn/reg/submit', [validateCSRF, apiSetup, webauthnRegSubmit]);
    app.post('/auth/webauthn/reg/commit', [validateCSRF, apiSetup, webauthnRegCommit]);
    app.post('/auth/webauthn/auth/submit', [validateCSRF, apiSetup, webauthnAuthSubmit]);
    app.post('/auth/webauthn/auth/commit', [validateCSRF, apiSetup, webauthnAuthCommit]);
    app.get('/auth/webauthn', WebauthnPage);
};
