const langSetup = require('../common/langSetup');
const apiSetup = require('../common/apiSetup');
const getUatraitsData = require('../common/getUatraitsData');
const getYaExperimentsFlags = require('../common/getYaExperimentsFlags');
const createState = require('../common/createState');
const getCountry = require('../common/getCountry');
const multiAuthAccountsSetup = require('../common/multiAuthAccountsSetup').getAccounts;
const getMetrics = require('../common/getMetrics');
const showPlus = require('../common/plusGuard').showPlus;
const getTrack = require('../common/getTrack');
const profileStateSetup = require('../common/profileStateSetup');
const rumCounterSetup = require('../common/rumCounterSetup');

module.exports.WebauthnPage = [
    apiSetup,
    getYaExperimentsFlags,
    getUatraitsData,
    langSetup,
    getTrack({type: 'authorize'}, true),
    getCountry,
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    profileStateSetup,
    createState,
    getMetrics({
        header: 'Webauthn'
    }),
    rumCounterSetup,
    (req, res) => {
        res.render(`react.webauthn.${res.locals.language}.jsx`);
    }
];
