var clusterMaster = require('cluster-master');
var cluster = require('cluster');
const ALL_SERVICES = require('./routes/profile.delete-data.js').ALL_SERVICES;
const yasmkit = require('yasmkit');

yasmkit.config('debug', false);
// yasmkit.config('hosts', 'CON');
// yasmkit.config('tag', `itype=passportfrontend;ctype=${process.env.NODE_ENV};prj=passport-frontend`);
yasmkit.server.run({port: 10299});

try {
    const handles = ['status', 'delete'];
    const counters = ['success', 'fail'];

    ALL_SERVICES.forEach((service) => {
        handles.forEach((handle) => {
            counters.forEach((counter) => {
                const metric = `deleteData.${service}.${handle}.${counter}_counter`;

                yasmkit.metrics.addSummLine(metric);
            });
        });
    });
} catch (e) {
    console.error(e);
}

clusterMaster({
    exec: './app.js',
    size: 8,
    repl: false,
    onMessage: function(msg) {
        yasmkit.addEvent(msg);
    }
});

cluster.on('exit', function(worker, code, signal) {
    console.error(
        'ERROR worker.exited, [%s] pid: %s, code: %s, log: |%s:%s|',
        new Date(),
        worker.process.pid,
        code || signal,
        worker.id,
        worker.process.pid
    );
});
