// This is an utils file for proxying afisha gql
// endpoint is /graphql
// index will show favs
// to start server run with "serv" (node file.js serv)

const fs = require('fs');
const axios = require('axios');
const https = require('https');
const express = require('express');

const tvm = require('../lib/tvm');
const TicketsExtractor = tvm.TicketsExtractor;
const SERVICE_ALIASES = tvm.SERVICE_ALIASES;
// ie path to the query file
const queries = require('../plibs/papi/Afisha/queries');

const port = 1338;
const cert = '/etc/ssl/certs/ca-certificates.crt';

const userIp = '2a02:6b8:0:40c:41c0:c61c:fc6:35dc';
const host = 'passport.yandex.ru';
const yandexuid = ''; // enter here
const sessionId = ''; // and here (cookie session_id or session2)

const httpsAgent = new https.Agent({
    ca: fs.readFileSync(cert, {encoding: 'utf-8'})
});

const app = express();

class UserTicketFetch {
    constructor({blackboxTicket, blackboxEndPoint}) {
        this.blackboxEndPoint = blackboxEndPoint;
        this.blackboxTicket = blackboxTicket;

        this.bindAll();
    }

    bindAll() {
        this.getTicket = this.getTicket.bind(this);
        this.then = this.then.bind(this);
    }

    getTicket() {
        return axios
            .get(this.blackboxEndPoint, {
                httpsAgent,
                params: {
                    method: 'sessionid',
                    get_user_ticket: 'yes',
                    format: 'json',
                    sessionid: sessionId,
                    userip: userIp,
                    host: host
                },
                headers: {
                    'X-Ya-Service-Ticket': this.blackboxTicket
                }
            })
            .then(({data}) => {
                if (!data) {
                    return Promise.reject('Blackbox empty');
                }

                if (!data.user_ticket) {
                    return Promise.reject('User ticket empty');
                }

                this.userTicket = data.user_ticket;
            });
    }

    then(resolve, reject) {
        this.getTicket()
            .then(() =>
                resolve({
                    userTicket: this.userTicket
                })
            )
            .catch(reject);
    }
}

class GraphQlFetch {
    constructor({body, config: {afishaTicket, userTicket, httpsAgent}}) {
        this.afishaEndPoint = 'https://api.draqla.afisha.tst.yandex.net/graphql';
        this.afishaTicket = afishaTicket;
        this.userTicket = userTicket;
        this.httpsAgent = httpsAgent;
        this.body = body;

        this.bindAll();
    }

    bindAll() {
        this.extractGraphQLData = this.extractGraphQLData.bind(this);
        this.checkGraphQLErr = this.checkGraphQLErr.bind(this);
        this.processErr = this.processErr.bind(this);
        this.fetch = this.fetch.bind(this);
        this.then = this.then.bind(this);
    }

    fetch() {
        return axios.post(this.afishaEndPoint, this.body, {
            httpsAgent: this.httpsAgent,
            params: {
                query_name: 'testing-query'
            },
            headers: {
                'X-Ya-Service-Ticket': this.afishaTicket,
                'X-Ya-User-Ticket': this.userTicket
            }
        });
    }

    extractGraphQLData(res) {
        return Promise.resolve(res.data);
    }

    checkGraphQLErr(data) {
        if (data.errors) {
            return Promise.reject({errors: data.errors});
        }

        return data;
    }

    processErr(err) {
        if (err.response) {
            console.error(err.response.data);
            console.error(err.response.status);
            console.error(err.response.headers);
        } else if (err.errors) {
            err.errors.forEach((e) => console.error(e));
            return Promise.reject(err.errors);
        } else {
            console.error(err);
        }
        return Promise.reject(err);
    }

    then(resolve, reject) {
        this.fetch()
            .then(this.extractGraphQLData)
            .then(this.checkGraphQLErr)
            .catch(this.processErr)
            .then(resolve)
            .catch(reject);
    }
}

const requestGql = (body) => {
    const blackboxMiminoEndpoint = 'https://blackbox-mimino.yandex.net/blackbox';

    let serviceTickets = {};

    let userTicket = null;

    return Promise.resolve(new TicketsExtractor())
        .then(({tickets}) => {
            serviceTickets = tickets;
        })
        .then(() =>
            Promise.resolve(
                new UserTicketFetch({
                    blackboxTicket: serviceTickets[SERVICE_ALIASES.BLACKBOX_MIMINO],
                    blackboxEndPoint: blackboxMiminoEndpoint
                })
            )
        )
        .then((fetched) => {
            if (fetched) {
                userTicket = fetched.userTicket;
            }
        })
        .then(() =>
            Promise.resolve(
                new GraphQlFetch({
                    body,
                    config: {
                        afishaTicket: serviceTickets[SERVICE_ALIASES.AFISHA],
                        userTicket,
                        httpsAgent
                    }
                })
            )
        );
};

const getFavs = () =>
    requestGql({
        query: queries.favoriteEvents,
        variables: {pageLimit: 20, pageOffset: 0},
        yandexuid,
        userIp,
        lang: 'ru'
    }).catch((er) => {
        console.error(er);
    });

const printFavs = () =>
    getFavs().then((favs) => {
        // eslint-disable-next-line no-console
        console.log(JSON.stringify(favs, null, 2));
    });

if (process.argv.length > 2 && process.argv[2] === 'serv') {
    app.use(express.json());

    app.post('/graphql', (req, res) => {
        // eslint-disable-next-line no-console
        console.log('Received request');

        requestGql(req.body || {})
            .then((data) => {
                res.json(data);
            })
            .catch((er) => {
                res.json(er);
            });
    });

    app.listen(port, function() {
        // eslint-disable-next-line no-console
        console.log(`Started at ${port}`);
    });
} else {
    printFavs();
}
