/**
 * Initially authored by aandrosov@
 * @example node ./build-css.js output file1.styl file2.styl file3.styl
 */

var PATH = require('path');
var FS = require('fs');
var util = require('util');

var out = process.argv[2];
var outDir = PATH.dirname(out);

compile(out, util.format('@import "%s"', PATH.relative(outDir, process.argv[3])), process.argv[4]);

function compile(path, str, skipNanoislands) {
    skipNanoislands = skipNanoislands && skipNanoislands !== '0';

    var stylus = require('stylus');
    var relativeStylobate = PATH.relative(outDir, `${__dirname}/../node_modules/stylobate/index.styl`);
    var relativeStylobateIslands = PATH.relative(outDir, `${__dirname}/../node_modules/stylobate-islands/index.styl`);
    var relativeStylobateSkinNamespace = PATH.relative(outDir, `${__dirname}/stylus/namespace.styl`);
    var utilusPath = PATH.resolve(outDir, `${__dirname}/../node_modules/utilus.styl`);
    var ifIePath = PATH.resolve(outDir, `${__dirname}/../node_modules/if-ie.styl`);

    var handleError = function(err) {
        if (err) {
            console.error('** ERROR');
            console.error(err.name);
            console.error(err.message);
            console.error(`${err.filename}@${err.lineno}`);
            process.exit(1);
        }
    };

    var write = function(path, css) {
        // не пишем в stdout,
        // чтобы в случае ошибки не получить пустой файл
        // eslint-disable-next-line no-console
        console.log('Writing css for', path);
        FS.writeFileSync(path, css, 'utf-8');
    };

    var postcss = require('postcss');
    var autoprefixer = require('autoprefixer');

    var render = function(ie, browsers) {
        stylus(str)
            .set('filename', path)
            .set('resolve url', true)
            .set('paths', [__dirname, utilusPath, ifIePath])
            .define('url', stylus.resolver())
            .import(relativeStylobate)
            .import(relativeStylobateSkinNamespace)
            //.define('$init_islands_root', true)
            .import(relativeStylobateIslands)
            .define('ie', ie)
            .render(function(err, css) {
                handleError(err);

                var prefixedCSS = postcss([autoprefixer({browsers: browsers})]).process(css);
                var nanoislandsCssPath = `${__dirname}/../plibs/nanoislands/nanoislands`;

                if (ie) {
                    path += '.ie';
                    nanoislandsCssPath += '.ie';
                }

                var nanoIslands = !skipNanoislands
                    ? `${FS.readFileSync(
                          `${__dirname}/../plibs/nanoislands/libs/jquery-ui/jquery-ui.custom.css`
                      )}\n${FS.readFileSync(`${nanoislandsCssPath}.css`)}\n`
                    : '';

                write(`${path}.css`, nanoIslands + prefixedCSS);
            });
    };

    // For normal browsers
    render(false, ['ff >= 19', 'ie >= 9', 'opera >= 11', 'safari >= 5', 'chrome >= 25', 'android >= 4', 'ios >= 6']);

    // For IE
    render(true, ['ie 8', 'ie 7']);
}
