#!/usr/bin/env bash

### HOW TO ###
# sh ./tools/changelog.sh - новый минорный релиз: 0.2.1-0 -> 0.2.1-1
# sh ./tools/changelog.sh up - новый мажорный релиз: 0.2.1-12 -> 0.2.2-0
# sh ./tools/changelog.sh alias=mynewalias - новый фиче-релиз: 0.2.1-12 -> 0.2.1-12.mynewalias0
# sh ./tools/changelog.sh push - коммит и пуш нового changelog'a в релизную ветку
###

### CONSTANTS ###
changelog_file="./debian/changelog"
date=`date -R`
stable_version=0.2
###

### CALCULATE CURRENT BUILD VERSION ###
current_version=`head -n 1 ./debian/changelog | sed 's/.*(//g' | sed 's/).*//g'`
current_main_version=`echo $current_version | sed 's/-.*//' | sed 's/.*\.//'`
current_minor_version=`echo $current_version | sed 's/.*-//g'`
current_minor_version_number=`echo $current_minor_version | sed 's/.*[^0-9]//'`
current_minor_version_alias=`echo $current_minor_version | sed "s/$current_minor_version_number$//"`
###

release_ticket=`curl https://passport-pocket-service.n.yandex-team.ru/frontend/current_release -I | grep -e Location | egrep -o '[^/ ]*$'`
release_ticket_api="https://st-api.yandex-team.ru/v2/issues/$(echo $release_ticket)/comments"


if [[ $1 == 'push' ]]
then
    git_release_branch="rc-$stable_version.$current_main_version"
    git add .
    git commit -m "NOTASK: Build $current_version"
    git push origin $git_release_branch
    exit 0
fi

### CALCULATE NEW BUILD VERSION ###
new_minor_version_number=$((current_minor_version_number + 1))

new_minor_version="$new_minor_version_number"
if [[ $current_minor_version_alias != "" ]]
then
    new_minor_version="$current_minor_version_alias$new_minor_version_number"
fi

new_main_version="$current_main_version"
if [[ $1 == 'up' ]]
then
    new_main_version=$(($current_main_version + 1))
    new_minor_version="0"
fi

arg_name=`echo $1 | sed 's/=.*//'`
if [[ $arg_name == 'alias' ]]
then
    new_alias=`echo $1 | sed 's/alias=//'`
    current_minor_version_without_alias=`echo $current_minor_version | sed 's/\..*//'`
    new_minor_version_number="0"
    new_minor_version="$current_minor_version_without_alias.$new_alias$new_minor_version_number"
fi

new_version="$stable_version.$new_main_version-$new_minor_version"
###

### WRITE CHANGELOG ###
last_build_commit=`git log --pretty=oneline --no-color | grep -iP 'NOTASK: Build' | head -1 | cut -d' ' -f1`
changelog=`git log --pretty=oneline $last_build_commit.. | grep -P '([A-Z]+-\d+.*)' | cut -d' ' -f2- | sort | uniq | grep -P '^[A-Z]+-\d+'`

new_changelog="yandex-passport-frontend ($new_version) unstable; urgency=low\n\n"

while IFS='' read -ra commits; do
    for commit_message in "${commits[@]}"; do
        new_changelog+="  * $commit_message\n"
    done
done <<< "$changelog"

user_email=$DEBEMAIL
if [[ $user_email == '' ]]
then
    user_email=$EMAIL
fi

new_changelog+="\n -- $DEBFULLNAME <$user_email>  $date\n"

curl -H "Authorization: OAuth $(cat ~/oauth)" "$release_ticket_api"  -H "Content-Type: application/json" -XPOST -d "$(printf '{"text":"%s"}\n' "$new_changelog")"
echo -e "$new_changelog\n$(cat $changelog_file)" > $changelog_file
###
echo "$release_ticket"
echo "$release_ticket_api"
echo "CURRENT VERSION: $current_version"
echo "CURRENT MAIN VERSION: $current_main_version"
echo "CURRENT MINOR VERSION: $current_minor_version"
echo "CURRENT MINOR VERSION NUMBER: $current_minor_version_number"
echo "CURRENT MINOR VERSION ALIAS: $current_minor_version_alias"
echo "NEW MINOR VERSION NUMBER: $new_minor_version_number"
echo "NEW MINOR VERSION: $new_minor_version"
echo "NEW MAIN VERSION: $new_main_version"
echo "NEW VERSION: $new_version"

exit 0
