const {Graph} = require('@yandex-int/tkit');

const graph = new Graph({
    // Максимальное время сборки, после чего она будет остановлена (по-умолчанию, ограничений нет).
    lifetime: 90 * 60 * 1000,
    repo: {owner: 'passport-frontend', name: 'core'},
    failOnStepFailure: true
});

const graphConfig = {
    DEPS_NODE_MODULES: null,
    DEPS_CONFIG: null,
    DEPS_BORSCHIK: null,

    TEST: ['DEPS_NODE_MODULES', 'DEPS_BORSCHIK', 'DEPS_CONFIG'],

    BUILD_STYLE: ['DEPS_NODE_MODULES', 'DEPS_BORSCHIK', 'DEPS_CONFIG'],
    BUILD_CLIENTJS: ['DEPS_NODE_MODULES', 'DEPS_BORSCHIK', 'DEPS_CONFIG'],
    BUILD_CLIENTYATE: ['DEPS_NODE_MODULES', 'DEPS_BORSCHIK', 'DEPS_CONFIG'],
    BUILD_CLIENTJSX: ['DEPS_NODE_MODULES', 'DEPS_BORSCHIK', 'DEPS_CONFIG'],

    DEPLOY_MAPS: ['BUILD_STYLE', 'BUILD_CLIENTJS', 'BUILD_CLIENTJSX', 'BUILD_CLIENTYATE'],
    DEPLOY_STATIC: ['BUILD_STYLE', 'BUILD_CLIENTJS', 'BUILD_CLIENTJSX', 'BUILD_CLIENTYATE']
};

const steps = {
    DEPS_NODE_MODULES: ['make node_modules', {retry: true}],
    DEPS_CONFIG: 'make passport-dev',
    DEPS_BORSCHIK: 'cp build/s3/.borschik ./',

    TEST: 'npm run react-tests',

    BUILD_STYLE:
        'NPMCACHE=y NODE_OPTIONS="--max_old_space_size=4096" NODE_ENV=production ENV=production make styleonly',
    BUILD_CLIENTJS:
        'NPMCACHE=y NODE_OPTIONS="--max_old_space_size=4096" NODE_ENV=production ENV=production make clientjs',
    BUILD_CLIENTYATE:
        'NPMCACHE=y NODE_OPTIONS="--max_old_space_size=4096" NODE_ENV=production ENV=production make clientyate',
    BUILD_CLIENTJSX:
        'NPMCACHE=y NODE_OPTIONS="--max_old_space_size=4096" NODE_ENV=production ENV=production make clientjsx',

    DEPLOY_MAPS: './tools/source-map-upload-s3.sh',
    DEPLOY_STATIC: 'YENV=production npm run deploy:static'
};

graph.run(graphConfig, steps).catch((err) => {
    console.error(err);
    process.exit(1);
});
