module.exports = class CleanUpStatsPlugin {
    constructor(name) {
        this.name = name;
    }

    apply(compiler) {
        compiler.hooks.done.tap('CleanUpStatsPlugin', (stats) => {
            const children = stats.compilation.children;

            if (Array.isArray(children)) {
                stats.compilation.children = children.filter((child) => child.name.indexOf(this.name) !== 0);
            }
        });
    }
};
