import os
import re
import glob
import csv
from itertools import chain


def getI18NKeys():
    i18nRegExp = 'i18n\((\'|\")([^)%]+)\\1\)'
    i18nYateRegExp = 'i18n\((?:\'|\")%([^\'\"]+)'
    i18nYateFieldErrorRegExp = "Error\(\'[^\']+', '%([^\']+)'\)"
    i18nYateFielPropsRegExp = "(?:setLabel|setHint|setPlaceholder)\(\'%([^\']+)\'\)"

    i18nKeys = []
    yateKeys = []
    paths = ('./blocks', './pages', './routes')

    for root, dirs, files in chain.from_iterable(os.walk(path) for path in paths):
        for file in files:
            result = re.search('\.(js|jsx|yate)$', file)

            if result is None:
                continue

            with open(os.path.join(root, file)) as f:
                content = f.read()

                i18n = re.findall(i18nRegExp, content)
                i18nYate = re.findall(i18nYateRegExp, content)
                i18nYateFieldError = re.findall(i18nYateFieldErrorRegExp, content)
                i18nYateFieldProps = re.findall(i18nYateFielPropsRegExp, content)

                for i18nKey in i18n:
                    i18nKeys.append(i18nKey[1])

                for i18nKey in i18nYate:
                    yateKeys.append(i18nKey)

                for i18nKey in i18nYateFieldError:
                    yateKeys.append(i18nKey)

                for i18nKey in i18nYateFieldProps:
                    yateKeys.append(i18nKey)

    manualYateKeys = [
        'phone-confirm_code_label_short',
        'phone-confirm_code_label',
        'profile.access.2fa.smslink',
        'semiauto.service.mail',
        'semiauto.service.disk',
        'semiauto.service.market',
        'semiauto.service.metrika',
        'semiauto.service.search',
        'semiauto.service.money',
        'semiauto.service.music',
        'internal',
        'password.empty',
        'password.likelogin',
        'password.tooshort',
        'password.toolong',
        'password.weak',
        'password.prohibitedsymbols',
        'password.likeoldpassword',
        'password.foundinhistory',
        'password.found_in_history',
        'password.likephonenumber',
        'password_auth_date.empty',
        'disabled',
        'likeoldpassword',
        'foundinhistory',
        'deleted',
        'crap',
        'account_not_found',
        'badlog_blocked',
        'import.account_not_found',
        'AutoLogin.dberror',
        'pdd_password_change_forbidden',
        'without_password',
        'social_without_password',
        'request_pdd_admin',
        'complaine.head',
        'ErrorsTexts.title.error',
        'ErrorsTexts.sessionidoverflow_reg',
        'ErrorsTexts.notfound',
        'Complains.badrequest',
        'MendTexts.registrationalreadycompletederror',
        'MendTexts.registrationalreadycompletederror',
        'MendTexts.sessionidoverflow_reg',
        'MendTexts.notfound',
        'title.restorefor',
        'title.changepasswordfor',
        'ErrorsTexts.badlog',
        'ErrorsTexts.badlog_2fa',
        'ErrorsTexts.badlog_blocked',
        'ErrorsTexts.deleted',
        'import.sms_limit_exceeded',
        'ErrorsTexts.internal',
        'ErrorsTexts.retry',
        'ErrorsTexts.auth_try_again',
        'ErrorsTexts.nodomain',
        'ErrorsTexts.domainnotfound',
        'field_human-confirmation_errors_unconfirmed',
        'ErrorsTexts.sessionidoverflow',
        'ErrorsTexts.account_compromised',
        'session_invalid',
        'blocked_with_money',
        'MendTexts.sessionidoverflow',
        'session_invalid_mend',
        'creg_misspasswd_2fa',
        'creg_misspasswd',
        'ErrorsTexts.subscr_err',
        'profile.journal.enter-imap',
        'profile.journal.enter-xmpp',
        'profile.journal.enter-webdav',
        'profile.journal.enter-calendar',
        'profile.journal.enter-browser',
        'profile.journal.enter-mobile',
        'profile.journal.force-pass-change',
        'profile.journal.pass-change',
        'profile.journal.change-personal-data',
        'profile.journal.bind-phone',
        'profile.journal.unbind-phone',
        'profile.journal.add-secure-phone',
        'profile.journal-delete-secure-phone',
        'profile.journal.replace-phone',
        'profile.journal-add-email',
        'profile.journal.remove-email',
        'profile.journal.2fa-enable',
        'profile.journal.2fa-migrate',
        'profile.journal.2fa-disable',
        'profile.journal.appwd-enable',
        'profile.journal.appwd-disable',
        'profile.journal.restoration',
        'profile.journal.restore-entities-flushed',
        'profile.journal.glogout',
        'profile.journal.change-kq',
        'profile.journal.secure-phone-bound',
        'profile.journal.secure-phone-changed',
        'profile.journal.secure-phone-deleted',
        'profile.journal.personal-hint',
        'profile.journal.city',
        'profile.journal.country',
        'profile.journal.timezone',
        'profile.journal.name',
        'profile.journal.surname',
        'profile.journal.birthday',
        'profile.journal.sex',
        'profile.journal.displayname',
        'profile.journal.female',
        'profile.journal.male',
        'profile.journal.email-added',
        'profile.journal.email-removed',
        'profile.journal.email-remove-all',
        'profile.journal.glogout',
        'profile.journal.kq-changed',
        'profile.journal.kq-removed',
        'profile.journal.password-changed',
        'profile.journal.password-removed',
        'profile.journal.web-sessions-revoked',
        'profile.journal.tokens-revoked',
        'profile.journal.app-passwords-revoked',
        'profile.journal.change-personal-data',
        'profile.journal.secure-phone-bound',
        'profile.journal.secure-phone-changed',
        'profile.journal.secure-phone-deleted',
        'profile.journal.semi_auto',
        'profile.journal.restore-link',
        'profile.journal.restore-by',
        'profile.journal.phone-and-2fa_factor',
        'profile.journal.2fa-disable',
        'profile.journal.personal-email',
        'profile.journal.personal-phone'
        'profile.journal.personal-hint'
        'profile.journal.phone-set',
        'profile.journal.phone-unset',
        'mode_oauth_error_title',
        'mode_oauth_error_message',
        'session_error_title',
        'session_error_message',
        'Common.nopasswd',
        'complete_social',
        'password_change_forbidden',
        'account.without_password',
        'ErrorsTexts.internal',
        'ErrorsTexts.auth_try_again',
        'ErrorsTexts.account_compromised',
        'password.pdd.forbidden',
        'account_without_password',
        'ErrorsTexts.subscr_err',
        'subscriptions.account-disabled',
        'subscriptions.user-not_verified',
        'profile.social.service-market',
        'profile.social.service-search',
        'profile.social.service-mail',
        'profile.social.service-news',
        'sessionid-overflow',
        'account-disabled',
        'profile.social.profile-invalid',
        'internal-exception',
        'session.invalid',
        'sessionid.invalid',
        'import.sms_internal_error',
        'AutoLogin.dberror',
        'ErrorsTexts.restart_restore',
        'restore.email.changed',
        'restart_restore_process',
        'mend.restore.email.changed',
        'restore_complete_autoregistered',
        'restore_domain_not_served',
        'restore_fio_limit_exceeded',
        'MendTexts.sessionidoverflow_restore',
        'twofa_form_not_matched',
        'restore.phone.alias',
        'mail.title',
        'mail.description',
        'narod.title',
        'narod.description',
        'fotki.title',
        'fotki.description',
        'direct.title',
        'direct.description',
        'billing.title',
        'billing.description',
        'money.title',
        'money.description',
        'rsya.title',
        'rsya.description',
        'market.title',
        'market.description',
        'tvprogramma.title',
        'tvprogramma.description',
        'afisha.title',
        'afisha.description',
        'calendar.title',
        'calendar.description',
        'video.title',
        'video.description',
        'webmaster.title',
        'webmaster.description',
        'metrika.title',
        'metrika.description',
        'maps.title',
        'maps.description',
        'narodmap.title',
        'narodmap.description',
        'music.title',
        'music.description',
        'disk.title',
        'disk.description',
        'partners-news.title',
        'partners-news.description',
        'work.title',
        'work.description',
        'realty.title',
        'realty.description',
        'postoffice.title',
        'postoffice.description',
        'avia.title',
        'avia.description',
        'toloka.title',
        'toloka.description',
        'telefonia.title',
        'telefonia.description',
        'profile.security.change-pwd',
        'profile.security.change-pass',
        'profile.security.title_pwd-simple',
        'profile.security.field-pwd_simple',
        'profile.security.title_pwd-old',
        'profile.security.field-pwd_old',
        'profile.security.title_pwd-toold',
        'profile.security.field-pwd_toold',
        'profile.security.title_pwd-date',
        'profile.security.field-pwd_ok',
        'profile.security.next-btn',
        'profile.securiy.field-no-phone',
        'profile.securiy.field-phone_hint',
        'profile.security.bind-phone_now',
        'profile.security.bind-phone',
        'profile.securiy.field-phone_clarify',
        'profile.securiy.field-phone_bind',
        'profile.security.replace-phone_btn',
        'profile.security.confirm-phone',
        'profile.securiy.field-phone_binded',
        'profile.security.edit-phone',
        'profile.security.field-email_bind',
        'profile.security.bind-email_hint',
        'profile.security.bind-address_now',
        'profile.security.bind-address',
        'profile.security.field-binded-emails',
        'profile.security.emails-ok',
        'profile.security.edit-plural-btn',
        'profile.security.ok-btn',
        'profile.security.field-email-clarify',
        'profile.security.field-email_hint',
        'profile.security.replace-phone_btn',
        'profile.security.confirm-address',
        'profile.security.field-binded-email',
        'profile.security.edit-btn',
        'profile.security.next-btn',
        'ya_money_support_msg',
        'need.password',
        'button.continue',
        'button.confirm',
        'button.close',
        'need.changepassword',
        'password_session-warning_no-link',
        'password_session-warning',
        'password_edit-logout',
        'password_logout',
        'tokens_list_title',
        'password_revoke_accesses',
        'intro2',
        'save',
        'title',
        'register',
        'head',
        'description',
        'empty',
        'denied',
        'changepassword_cant_auto_restore',
        'IsPasswordSimple',
        'fishing',
        'expiredpw',
        'account_hacked_phone',
        'account_hacked_no_phone',
        'serviceTitles.DomainFor',
        'password_goto_support'
    ]

    yateKeys = list(set(yateKeys + manualYateKeys))
    yateI18NKeys = []

    for file in glob.glob('./loc/*.ru.loc'):
        with open(file) as f:
            content = f.read()

            for yateKey in yateKeys:
                i18n = re.findall('\s*(' + yateKey + ')\s*', content)

                if len(i18n) == 0:
                    continue

                keySet = re.sub(r'\./loc/(.*)\.ru\.loc', '\\1', file)

                yateI18NKeys.append(keySet + '.' + yateKey)

    return list(set(i18nKeys + yateI18NKeys))

tankerKeys = getI18NKeys()

with open('./tanker.csv', 'w+') as csvfile:
    csvWriter = csv.writer(csvfile, delimiter=',', quotechar='|', quoting=csv.QUOTE_MINIMAL)

    for tankerKey in tankerKeys:
       keyParts = tankerKey.split('.')
       csvWriter.writerow([keyParts[0], '.'.join(keyParts[1:])])
