// var fs = require('fs');
var constDependency = require('webpack/lib/dependencies/ConstDependency');

var cl = require('colors');

const pluginName = 'I18nWebpackPlugin';

function i18n(localization, funcName, lang, bundleName) {
    this.localization = localization;
    this.funcName = funcName || 'i18n';
    this.lang = lang;
    this.bundleName = bundleName;
}

i18n.prototype.getPlural = () => ({
    /* eslint-disable object-shorthand */
    ru: function(params) {
        var count = isNaN(parseInt(params.count, 10)) ? 0 : params.count;

        if (count === 0) {
            return params.none;
        }

        var lastNumber = count % 10;
        var lastNumbers = count % 100;

        return lastNumber === 1 && lastNumbers !== 11
            ? params.one
            : lastNumber > 1 && lastNumber < 5 && (lastNumbers < 10 || lastNumbers > 20)
            ? params.some
            : params.many;
    },
    en: function(params) {
        var count = isNaN(parseInt(params.count, 10)) ? 0 : params.count;

        if (count === 0) {
            return params.none;
        }

        return count === 1 ? params.one : params.some;
    },
    tr: function(params) {
        var count = isNaN(parseInt(params.count, 10)) ? 0 : params.count;

        if (count === 0) {
            return params.none;
        }

        var lastNumber = count % 10;
        var lastNumbers = count % 100;

        return lastNumber === 1 && lastNumbers !== 11
            ? params.one
            : lastNumber > 1 && lastNumber < 5 && (lastNumbers < 10 || lastNumbers > 20)
            ? params.some
            : params.many;
    },
    uk: function(params) {
        var count = isNaN(parseInt(params.count, 10)) ? 0 : params.count;

        if (count === 0) {
            return params.none;
        }

        var lastNumber = count % 10;
        var lastNumbers = count % 100;

        return lastNumber === 1 && lastNumbers !== 11
            ? params.one
            : lastNumber > 1 && lastNumber < 5 && (lastNumbers < 10 || lastNumbers > 20)
            ? params.some
            : params.many;
    }
});

i18n.prototype.getPluralKeys = function(params) {
    var self = this;
    var result = {};

    params.forEach(function(param) {
        result[param.key.name] = param.value.name
            ? param.value.name
            : self.localization[param.value.value] || param.value.value;

        if (param.value.value && !self.localization[param.value.value]) {
            self.warn(param.value.value);
        }
    });

    return result;
};

i18n.prototype.pluralAdv = function(entry, lang) {
    var result;
    var entryString;
    var plurals = this.getPlural();
    var pluralFunction = (plurals[lang] && plurals[lang].toString()) || plurals['en'].toString();
    var draftPlural = '(%pluralFunction%)(%entry%)';
    var count = entry.count;

    entry.count = '%_____count_____%';
    entryString = JSON.stringify(entry);

    result = draftPlural
        .replace('%pluralFunction%', pluralFunction)
        .replace('%entry%', entryString)
        .replace('"%_____count_____%"', count);

    return result;
};

i18n.prototype.processArgs = function(entry, subs) {
    var result = entry;
    var draft = '(function() { return %entry% })()';
    var isFunction = /^\(function/.test(entry);
    var anyIdentifier = subs.some(function(sub) {
        return sub.type === 'Identifier';
    });

    subs.forEach(function(sub, index) {
        var keyRegExp = new RegExp(`%${++index}`, 'g');
        var nameRegExp = new RegExp('%_____sub.name_____%', 'g');

        if (sub.type === 'Identifier') {
            result = result.replace(keyRegExp, '" + %_____sub.name_____% + "');
            result = result.replace(nameRegExp, sub.name);
        } else {
            result = result.replace(keyRegExp, sub.value);
        }
    });

    if (anyIdentifier || isFunction) {
        result = draft.replace('%entry%', isFunction ? result : `"${result}"`);
    } else {
        result = JSON.stringify(result);
    }

    return result;
};

i18n.prototype.apply = function(compiler) {
    var self = this;
    var key = '';

    compiler.hooks.compilation.tap(pluginName, (compilation, {normalModuleFactory}) => {
        const handler = (parser) => {
            parser.hooks.call.for(self.funcName).tap(pluginName, (expr) => {
                if (expr.arguments[0].type === 'ObjectExpression') {
                    key = self.getPluralKeys(expr.arguments[0].properties);
                } else {
                    key = String(expr.arguments[0].value);
                }

                var result = typeof key === 'string' ? self.localization[key] || key : key;

                if (typeof result === 'string' && self.localization[key] && expr.arguments.length > 1) {
                    result = self.processArgs(result, expr.arguments.slice(1));
                } else if (typeof result === 'object') {
                    result = self.pluralAdv(result, self.lang);

                    if (expr.arguments.length > 1) {
                        result = self.processArgs(result, expr.arguments.slice(1));
                    }
                } else {
                    result = JSON.stringify(result);
                }

                if (typeof key === 'string' && !self.localization[key]) {
                    self.warn(key);
                }

                // fs.writeFileSync(
                // '/home/yakushevsky/i18n.log',
                // `${self.bundleName}\t${key}\n`, {flag: 'a+'}, () => {});

                parser.state.current.addDependency(new constDependency(result, expr.range));
                return true;
            });
        };

        normalModuleFactory.hooks.parser.for('javascript/auto').tap(pluginName, handler);
        normalModuleFactory.hooks.parser.for('javascript/dynamic').tap(pluginName, handler);
        normalModuleFactory.hooks.parser.for('javascript/esm').tap(pluginName, handler);
    });
};

i18n.prototype.warn = function(key) {
    if (!key) {
        return;
    }

    // eslint-disable-next-line no-console
    console.log(cl.yellow('Missing localisation, key:', key, ', language:', this.lang));
};

module.exports = i18n;
