from geobase6 import Lookup, Linguistics
import io, json
import icu

lookup = Lookup('/var/cache/geobase/geodata6.bin')
langs = ['ru', 'en', 'uk', 'tr', 'fr']
countries = {}
cities = {}
locales = {
    'en': 'en_US-UTF-8',
    'ru': 'ru_RU.UTF-8',
    'uk': 'uk_UA.UTF-8',
    'fr': 'fr_FR.UTF-8',
    'tr': 'tr_TR.UTF-8'
}

# types:
# 6 - city
# 3 - country

print 'Getting data'

for item in lookup.get_regions_by_type(6):
    _country = None
    country = None
    city = None

    for lang in langs:
        country = lookup.get_region_by_id(lookup.get_country_id(item['id'], 'ru' if lang == 'ru' else 'com'))

        if country and country['type'] == 3:
            city = {
                'id': item['id'],
                'countryId': country['id'],
                'countryIso': country['iso_name'].lower()
            }

            if lang == 'en':
                city['name'] = item['en_name']
                city['countryName'] = country['en_name']

            elif lang == 'ru':
                city['name'] = item['name']
                city['ename'] = item['en_name']

                city['countryName'] = country['name']
                city['countryEname'] = country['en_name']
            else:
                localizeRegion = lookup.get_linguistics(item['id'], lang)
                localizeCountry = lookup.get_linguistics(country['id'], lang)
                city['ename'] = item['en_name']
                city['name'] = localizeRegion.nominative if localizeRegion.nominative else item['en_name']

                city['countryEname'] = country['en_name']
                city['countryName'] = localizeCountry.nominative if localizeCountry.nominative else country['en_name']

            if not lang in cities:
                cities[lang] = []

            cities[lang].append(city)

            if 'countryName' in city:
                _country = {
                    'id': country['id'],
                    'iso': country['iso_name'].lower(),
                    'name': city['countryName']
                }

                if 'countryEname' in city:
                    _country['ename'] = city['countryEname']

                if not lang in countries:
                    countries[lang] = []

                countries[lang].append(_country)

for index, location in enumerate([countries, cities]):
    locationType = 'countries' if index == 0 else 'cities'

    for lang in langs:
        for item in location[lang]:
            for key in item:
                if key != 'id' and key != 'countryId':
                    item[key] = item[key].decode('utf-8')

        collator = icu.Collator.createInstance(icu.Locale(locales[lang]))
        location[lang] = { x['id']:x for x in location[lang] }.values() # unique items
        location[lang].sort(lambda x, y : collator.compare(x['name'], y['name']))

    print 'Writing ' + locationType
    with io.open('./lib/geo/' + locationType + '.json', 'w') as locationsFile:
        locationsFile.write(json.dumps(location, ensure_ascii = False, sort_keys=True, indent=4))
