#!/usr/bin/env bash

VERSION=$(cat ./debian/changelog | head -1 | sed 's/^.*(//' | sed 's/).*$//')

while [ $# -gt 0 ]; do
  case "$1" in
    --hotfix)
      HOTFIX="yes"
      shift
    ;;
  esac
done

if [ "$HOTFIX" == "yes" ]; then
    echo "HOTFIX $VERSION"
else
    echo "RELEASE $VERSION"

    echo "LOC UP"
    LOC_BRANCH=locdoc-passport_whitelist make loc
    git add loc tools/tanker-sync.history.json lib/passport-errors/messages.json
    git commit -m "NOTASK: loc up" --no-verify

    echo "GEO UP"
    make geo
    git add ./lib/geo
    git commit -m "NOTASK: geo up" --no-verify
fi

npm version "$VERSION"
arc add package.json package-lock.json

arc add debian
arc commit -m "NOTASK: Build $VERSION" --no-verify

exit 0
