const {exec} = require('child_process');

const tankerSyncConfig = {
    Plashka: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Plashka.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Plashka'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1'
        }
    },
    Frontend: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Frontend.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Frontend'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Enabling2fa: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Enabling2fa.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Enabling2fa'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    ProfileAccess: {
        exportFile: 'ProfileAccess.${LNG}.${FORMAT}',
        projectName: 'oauth',
        keySets: ['frontend.access'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Time: {
        exportFile: 'Time.${LNG}.${FORMAT}',
        projectName: 'oauth',
        keySets: ['frontend.time'],
        formats: ['loc', 'json'],
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    EULA: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'EULA.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['EULA'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    SimpleReg: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'SimpleReg.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['SimpleReg'],
        formats: ['loc', 'json'],
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Common: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Common.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['common'],
        formats: ['loc', 'json'],
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Sex: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Sex.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Sex'],
        formats: ['loc', 'json'],
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Texts: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Texts.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Texts'],
        formats: ['loc', 'json'],
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Date: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Date.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Date'],
        formats: ['loc', 'json'],
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Login: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Login.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Login'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Restore: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Restore.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Restore'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Errors: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Errors.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Errors'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Mend: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Mend.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Mend'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    ProfileSocial: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'ProfileSocial.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['ProfileSocial'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Semiauto: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Semiauto.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Semiauto'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Restoration: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Restoration.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Restoration'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Social: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Social.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Social'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Multiauth: {
        exportFile: 'Multiauth.${LNG}.${FORMAT}',
        projectName: 'multiauth',
        keySets: ['dropdown'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Phones: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Phones.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Phones'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    ServicesSubscriptions: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'ServicesSubscriptions.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['ServicesSubscriptions'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    ProfileJournal: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'ProfileJournal.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['ProfileJournal'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Navigation: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Navigation.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Navigation'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Migrating2fa: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Migrating2fa.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['Migrating2fa'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    AuthChallenges: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'AuthChallenges.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['AuthChallenges'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    ProfileSecurity: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'ProfileSecurity.${LNG}.${FORMAT}',
        projectName: 'passport',
        keySets: ['ProfileSecurity'],
        formats: ['loc', 'json'],
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    tankerDynamic: {
        exportFile: '../lib/tanker/tanker.dynamic.${LNG}.js',
        loadUrl: 'https://tanker-api.yandex-team.ru/tools/generate/i18n.xml',
        projectName: 'tanker',
        keySets: ['dynamic'],
        formats: ['js'],
        options: {
            path: 'i18n',
            type: 'js',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        },
        forceLoad: true
    },
    months: {
        exportFile: 'months.${LNG}.json',
        projectName: 'tanker',
        keySets: ['months'],
        formats: ['json'],
        options: {
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    Months: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'Months.${LNG}.loc',
        projectName: 'passport',
        keySets: ['Months'],
        formats: ['loc'],
        options: {
            include: 'no',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        },
        afterSaveCallback(file) {
            exec(`sed -i '/^name /d' ${file}`);
        }
    },
    sids: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'sids.json',
        projectName: 'passport',
        keySets: ['SidsDescriptions'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    auth: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'auth.json',
        projectName: 'passport',
        keySets: [
            '_AUTH_',
            'Errors',
            'AdmRegSetPass',
            'MDFillInfo',
            'Passwd',
            'Frontend',
            'Profile2',
            'Errors',
            'Mend',
            'Message',
            'Restore',
            'common',
            'FlashMessages'
        ],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            'all-forms': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    monthsMerged: {
        exportFile: 'months.json',
        projectName: 'tanker',
        keySets: ['months'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    passportErrorsMessages: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: '../lib/passport-errors/messages.json',
        projectName: 'passport',
        keySets: ['Errors'],
        formats: ['json'],
        needMerge: true,
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    multiauth: {
        exportFile: 'multiauth.json',
        projectName: 'multiauth',
        keySets: ['dropdown'],
        formats: ['json'],
        needMerge: true,
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    frontend: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'frontend.json',
        projectName: 'passport',
        keySets: ['Frontend'],
        formats: ['json'],
        needMerge: true,
        options: {
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    profileSocial: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'profilesocial.json',
        projectName: 'passport',
        keySets: ['ProfileSocial'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    common: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'common.json',
        projectName: 'passport',
        keySets: ['common'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    subscriptions: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'subscriptions.json',
        projectName: 'passport',
        keySets: ['ServicesSubscriptions'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    subs: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'subs.json',
        projectName: 'passport',
        keySets: ['ProfileSubs'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    profileJournal: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'profilejournal.json',
        projectName: 'passport',
        keySets: ['ProfileJournal'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    profilesecurity: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: 'profilesecurity.json',
        projectName: 'passport',
        keySets: ['ProfileSecurity'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    },
    social: {
        exportFile: 'social.json',
        projectName: 'social',
        keySets: ['choose', 'common', 'error', 'greet', 'headPage', 'profiles'],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        },
        languages: [
            'ru',
            'en',
            'tr',
            'uk',
            'be',
            'et',
            'fi',
            'fr',
            'hu',
            'hy',
            'id',
            'ka',
            'kk',
            'tt',
            'uz',
            'he',
            'ky',
            'pt'
        ]
    },
    locs: {
        branchName: process.env.LOC_BRANCH || 'master',
        exportFile: '_locs.json',
        projectName: 'passport',
        keySets: [
            '_AUTH_',
            'OneDomik',
            'OneDomikCustoms',
            'Family',
            'Frontend',
            'Errors',
            'EmailConfirm',
            'Mend',
            'Months',
            'Profile',
            'Profile2',
            'DeepSync',
            'DeleteData',
            'ProfileDelete',
            'ProfileSocial',
            'ProfileSecurity',
            'Plus',
            'common',
            'ProfileJournal',
            'ProfileSubs',
            'Header',
            'Login',
            'Enabling2fa',
            'Restore',
            'Navigation',
            'Phones',
            'Verification',
            'EULA',
            'Dashboard',
            'Favorites',
            'UserApprove',
            'AdditionalDataRequest',
            'Number',
            'TakeOut',
            'Subscriptions',
            'Social',
            'Passwd'
        ],
        formats: ['json'],
        needMerge: true,
        options: {
            status: 'unapproved',
            'flat-keyset': '1',
            'all-forms': '1',
            languages: ['ru', 'en', 'tr', 'uk', 'id', 'fr', 'fi', 'kk', 'uz', 'he', 'ky', 'pt']
        }
    }
};

module.exports = tankerSyncConfig;
