from geobase6 import Lookup
import io, json

lookup = Lookup("/var/cache/geobase/geodata6.bin")
langs = ['ru', 'en', 'uk', 'tr']
timezones = {}

print 'Getting time zones'
for timezone in lookup.get_known_timezones():
    for lang in timezone.desc_langs_with_offset.keys():
        if lang in langs:
            if not lang in timezones:
                timezones[lang] = []

            if timezone.desc_langs[lang] != '':
                name = timezone.desc_langs_with_offset[lang].decode('utf8').split(',', 3)

                if len(name) > 3:
                    name = name[0:3]

                timezones[lang].append({
                    'text': ', '.join(name),
                    'val': timezone.name,
                    'offset': timezone.offset_readable,
                    'sortField': timezone.offset_seconds
                })

for lang in langs:
    timezones[lang] = { x['text']:x for x in timezones[lang] }.values() # unique items
    timezones[lang].sort(lambda x, y : cmp(x['sortField'], y['sortField']))
    for timezone in timezones[lang]: del timezone['sortField']

print 'Writing time zones'
with io.open('./lib/geo/timezones.json', 'w') as timezonesFile:
    timezonesFile.write(json.dumps(timezones, ensure_ascii = False, sort_keys=True, indent=4))
