import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import {bindActionCreators} from 'redux';
import {Route, Switch, withRouter} from 'react-router-dom';
import assign from 'lodash/assign';

import OneDomik from '@blocks/auth/one_domik.jsx';
import {handleBack} from '@blocks/common/actions';
import {Footer} from '@components/Footer/Footer.jsx';
import {Spin} from '@components/Spin';
import {Message} from '@blocks/auth/message/message.jsx';

import routes from './routes';

const taglines = {
    appmetrica: i18n('OneDomikCustoms.Tagline.appmetrica.welcome'),
    audience: i18n('OneDomikCustoms.Tagline.audience.welcome'),
    connect: i18n('OneDomikCustoms.Tagline.connect.welcome'),
    contest: i18n('OneDomikCustoms.Tagline.contest.welcome'),
    serp_disk: i18n('OneDomikCustoms.Tagline.serp.serp_disk'),
    serp_ugc: i18n('OneDomikCustoms.Tagline.serp.serp_ugc'),
    serp_default: i18n('OneDomikCustoms.tagline.serp.serp_default'),
    toloka: i18n('OneDomikCustoms.Tagline.toloka.welcome'),
    telephony: i18n('OneDomikCustoms.Tagline.telephony.welcome'),
    music: i18n('OneDomikCustoms.Tagline.music.music_default'),
    health: i18n('OneDomikCustoms.Tagline.health.promo'),
    news_welcome1: i18n('OneDomikCustoms.Tagline.news.welcome1'),
    news_welcome2: i18n('OneDomikCustoms.Tagline.news.welcome2'),
    lyceum: i18n('OneDomikCustoms.Tagline.lyceum.welcome'),
    mail_exp: i18n('OneDomikCustoms.Tagline.mail.exp'),
    money_offer: i18n('OneDomikCustoms.Tagline.money.money_offer'),
    maps_favorites: i18n('OneDomikCustoms.Tagline.maps.maps_favorites'),
    maps_feedback: i18n('OneDomikCustoms.Tagline.maps.maps_feedback'),
    maps_reviews: i18n('OneDomikCustoms.Tagline.maps.maps_reviews'),
    mapsconstructor_new: i18n('OneDomikCustoms.Tagline.maps.mapsconstructor_new'),
    money_payment: i18n('OneDomikCustoms.Tagline.money.money_payment'),
    money_card: i18n('OneDomikCustoms.Tagline.money.money_card'),
    video: i18n('OneDomikCustoms.Tagline.video.welcome'),
    video_myvideo_add_new: i18n('OneDomikCustoms.Tagline.video.video_myvideo_add_new'),
    tune: i18n('OneDomikCustoms.Tagline.tune.welcome'),
    'disk_public-touch-copy': i18n('OneDomikCustoms.Tagline.disk.disk_public-touch-copy'),
    'disk_public-android-copy': i18n('OneDomikCustoms.Tagline.disk.disk_public-android-copy'),
    'disk_public-touch-copy-limit': i18n('OneDomikCustoms.Tagline.disk.disk_public-touch-copy-limit'),
    'disk_public-touch-comment': i18n('OneDomikCustoms.Tagline.disk.disk_public-touch-comment'),
    'disk_public-android-comment': i18n('OneDomikCustoms.Tagline.disk.disk_public-android-comment'),
    market_desktop_review: i18n('OneDomikCustoms.Tagline.market.market_desktop_review'),
    market_desktop_wishlist: i18n('OneDomikCustoms.Tagline.market.market_desktop_wishlist'),
    market_desktop_compare: i18n('OneDomikCustoms.Tagline.market.market_desktop_compare'),
    market_desktop_header: i18n('OneDomikCustoms.Tagline.market.market_desktop_header'),
    market_desktop_forum: i18n('OneDomikCustoms.Tagline.market.market_desktop_forum'),
    market_desktop_comment: i18n('OneDomikCustoms.Tagline.market.market_desktop_comment'),
    market_desktop_checkout: i18n('OneDomikCustoms.Tagline.market.market_desktop_checkout'),
    market_desktop_reviews: i18n('OneDomikCustoms.Tagline.market.market_desktop_reviews'),
    market_desktop_orders: i18n('OneDomikCustoms.Tagline.market.market_desktop_orders'),
    market_desktop_wishlist_save: i18n('OneDomikCustoms.Tagline.market.market_desktop_wishlist_save'),
    market_desktop_compare_save: i18n('OneDomikCustoms.Tagline.market.market_desktop_compare_save'),
    znatoki: i18n('OneDomikCustoms.Tagline.znatoki.welcome'),
    zen_pubs: i18n('OneDomikCustoms.Tagline.zen.zen_pubs'),
    passport_device: i18n('OneDomikCustoms.Tagline.passport.passport_device'),
    plus_gift: i18n('OneDomikCustoms.Tagline.plus.welcome'),
    plus_1year: i18n('OneDomikCustoms.Tagline.plus.plus_1year'),
    market_cashback: i18n('OneDomikCustoms.Tagline.market_cashback.welcome')
};

function mapDispatchToProps(dispatch) {
    const actionCreators = {
        handleBack
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state, ownProps) {
    return Object.assign({}, state, {
        location: ownProps.location
    });
}

class App extends Component {
    render() {
        const {common, one_domik, settings, customs, handleBack, location} = this.props;

        const passportPageContentClassNames = {
            'passport-Page-Content': true,
            'passport-Page-Content_theme_minimal': customs.minimal
        };

        const domikClassNames = {
            'passport-Domik': true,
            'passport-Domik_theme_minimal': customs.minimal
        };

        // domikClassNames[`passport-Domik_mode_${one_domik.mode}`] = true;

        return (
            <div className='passport-Page-Body'>
                {!settings.ua.isMobile && customs.display !== 'touch' && (
                    <div className={`passport-Page-Background passp-bg_${common.bgNumber}`} />
                )}
                {!settings.ua.isMobile && customs.display !== 'touch' && <span className='passport-Page-Helper' />}

                <div className={classnames(passportPageContentClassNames)}>
                    {one_domik.loading && (
                        <div className='passport-Page-loading'>
                            <Spin size='m' progress={true} />
                        </div>
                    )}
                    <div className={classnames(domikClassNames)}>
                        <h1 className='passport-Logo'>
                            <a href={common.yandex_url}>
                                {['en', 'fr', 'tr', 'fi', 'id'].indexOf(settings.lang) > -1 ? (
                                    <span className='passport-Icon passport-Icon_yandex_en' />
                                ) : (
                                    <span className='passport-Icon passport-Icon_yandex_ru' />
                                )}
                            </a>
                            {common.backPane !== null && (
                                <a
                                    className='passport-Domik-Return'
                                    data-metrics='Клик на Назад'
                                    onMouseDown={this.sendMetrics}
                                    onClick={handleBack}
                                />
                            )}
                        </h1>

                        {location.pathname !== '/auth/list' && customs.tagline && (
                            <Message text={taglines[customs.tagline]} />
                        )}

                        <OneDomik>
                            <Switch location={location}>
                                {routes.map((route) => (
                                    <Route
                                        key={route.path}
                                        path={route.path}
                                        exact={true}
                                        render={() => {
                                            const AuthPage = route.component;

                                            return <AuthPage {...this.props} />;
                                        }}
                                    />
                                ))}
                            </Switch>
                        </OneDomik>
                    </div>
                </div>

                {Boolean(!customs.minimal) && (
                    <footer className='passport-Page-Footer'>
                        <Footer
                            langlist={settings.langlist}
                            env={settings.env}
                            help={settings.help}
                            tld={settings.tld}
                            language={settings.lang}
                        />
                    </footer>
                )}
            </div>
        );
    }
}

App.propTypes = {
    settings: PropTypes.shape({
        ua: PropTypes.shape({
            isMobile: PropTypes.bool,
            isTablet: PropTypes.bool
        }).isRequired,
        tld: PropTypes.string,
        env: PropTypes.string,
        help: PropTypes.string,
        lang: PropTypes.string,
        langlist: PropTypes.array
    }).isRequred,
    location: PropTypes.shape({
        pathname: PropTypes.string.isRequired
    }).isRequired,
    handleBack: PropTypes.func.isRequired,
    one_domik: PropTypes.shape({
        loading: PropTypes.bool
    }).isRequired,
    customs: PropTypes.shape({
        minimal: PropTypes.bool,
        display: PropTypes.string,
        tagline: PropTypes.string
    }).isRegister,
    common: PropTypes.shape({
        bgNumber: PropTypes.number,
        backPane: PropTypes.string,
        yandex_url: PropTypes.string.isRequired
    }).isRequired
};

export default withRouter(connect(mapStateToProps, mapDispatchToProps)(App));
