import thunkMiddleware from 'redux-thunk';
import {combineReducers, createStore, applyMiddleware, compose} from 'redux';
import one_domik from '@blocks/auth/reducers';
import errors from '@blocks/auth/errors/reducers';
import additionalDataRequest from '@blocks/auth/additional_data_request/reducers';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';
import {connectRouter, routerMiddleware} from 'connected-react-router';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState, history) {
    return createStore(
        connectRouter(history)(
            combineReducers({
                errors,
                common,
                one_domik,
                additionalDataRequest,
                settings,
                captcha,
                metrics,
                monitoring,
                customs,
                social
            })
        ),
        initialState,
        compose(applyMiddleware(thunkMiddleware, routerMiddleware(history)), devTools)
    );
}

function settings(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function social(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function metrics(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function monitoring(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function customs(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}
