import '@yandex-int/rum-counter/dist/bundle/send';
import '@yandex-int/rum-counter/dist/bundle/implementation';
import '@yandex-int/rum-counter/dist/bundle/onload';
import React from 'react';
import ReactDOM from 'react-dom';
import {push} from 'react-router-redux';
import {Provider} from 'react-redux';
import {ConnectedRouter} from 'connected-react-router';
import createBrowserHistory from 'history/createBrowserHistory';
import passport from '@plibs/pclientjs/js/passport';
import api from '@blocks/api';
import oneDomik from '@blocks/auth';
import authorizedBroker from '@blocks/auth/authorized_broker';
import broker from '@blocks/auth/broker';
import magic from '@blocks/auth/magic/index.js';
import metrics from '@blocks/metrics';
import monitoring from '@blocks/monitoring';
import loadAuthCustomsStyles from '@blocks/loadAuthCustomsStyles';
import configureStore from './configureStore';
import App from './app.jsx';

$(function() {
    const $body = $('body');
    const initialState = $body.data('locals') || {};

    // const initialState = window.__REDUX_STATE__ || {};
    // const store = configureStore(initialState);
    const history = createBrowserHistory();
    const store = configureStore(initialState, history);
    const pane = store.getState().common.pane;
    // const askState = store.getState().additionalDataRequest.state;

    loadAuthCustomsStyles(initialState.settings);

    // delete window.__REDUX_STATE__;
    // $('#__REDUX_STATE__').remove();

    api.init(store);
    passport.init();
    broker.init(store);
    authorizedBroker.init(store);
    magic.init(store);
    metrics.init(store);
    monitoring.init(store);
    oneDomik.init(store);

    // if (askState) {
    //     store.dispatch(push('/auth/' + askState))
    // } else {
    if (pane) {
        store.dispatch(push(pane + location.search));
    }
    // }

    $body.removeAttr('data-locals');

    ReactDOM.render(
        <Provider store={store}>
            <ConnectedRouter history={history}>
                <App />
            </ConnectedRouter>
        </Provider>,
        document.getElementById('root')
    );

    $(window).on('load', function() {
        setTimeout(function() {
            monitoring.send({
                event: 'load'
            });
        }, 0);
    });
});
