import React from 'react';
import {Provider} from 'react-redux';
import {renderToString} from 'react-dom/server';
import configureStore from './configureStore';
import createMemoryHistory from 'history/createMemoryHistory';
import {StaticRouter} from 'react-router-dom';
import App from './app.jsx';

module.exports = function(state, location) {
    const history = createMemoryHistory();
    const store = configureStore(state, history);
    const context = {};

    return renderToString(
        <Provider store={store}>
            <StaticRouter location={location} context={context}>
                <App />
            </StaticRouter>
        </Provider>
    );
};
