import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Header} from '@blocks/morda/components/header/header.jsx';
import {Footer} from '@components/Footer/Footer.jsx';
import {NoJS} from '@components/NoJS/NoJS.jsx';
import {Password} from '@blocks/password/password.jsx';
import {PasswordMessage} from '@blocks/password/password_message.jsx';

class App extends Component {
    render() {
        const {
            settings,
            common,
            person,
            header,
            footer,
            password_status: {state}
        } = this.props;

        return (
            <div className='layout-inner'>
                <NoJS tld={settings.tld} />
                <Header displayName={person.displayName} {...header} {...settings} {...common} />
                <div className='grid'>{state ? <PasswordMessage code={state} /> : <Password />}</div>
                <Footer {...settings} {...footer} />
            </div>
        );
    }
}

App.propTypes = {
    password_status: PropTypes.object.isRequired,
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    header: PropTypes.object.isRequired,
    footer: PropTypes.object.isRequired
};

export default connect((state) => state)(App);
