import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import passport from '@plibs/pclientjs/js/passport';
import api from '@blocks/api';
import metrics from '@blocks/metrics';
import monitoring from '@blocks/monitoring';
import configureStore from './configureStore';
import App from './app.jsx';

const $body = $('body');
const csrf = $body.data('csrf');
const initialState = $body.data('locals') || {};

initialState.common.csrf = csrf;
const store = configureStore(initialState);

$body.removeAttr('data-locals');

api.init(store);
passport.init();

ReactDOM.render(
    <Provider store={store}>
        <App />
    </Provider>,
    document.getElementById('root')
);

if (process.env.NODE_ENV !== 'development') {
    metrics.init(store);
    monitoring.init(store);

    metrics.send(['показ страницы']);

    $(window).on('load', function() {
        setTimeout(function() {
            monitoring.send({
                event: 'load'
            });
        }, 0);
    });
}
