/* eslint-env node, jsx */

import 'core-js/fn/array/find';
import 'core-js/fn/object/assign';

import React from 'react';
import {renderToString} from 'react-dom/server';
import {Provider} from 'react-redux';
import App from './app.jsx';
import configureStore from './configureStore';

module.exports = function(state) {
    const store = configureStore(state);

    return renderToString(
        <Provider store={store}>
            <App />
        </Provider>
    );
};
