import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {NoJS} from '@components/NoJS/NoJS.jsx';
import Registration from '@blocks/registration/desktop/registration.jsx';

const App = ({settings}) => (
    <div className='layout-inner'>
        <NoJS tld={settings.tld} />
        <Registration />
    </div>
);

App.propTypes = {
    settings: PropTypes.object.isRequired
};

export default connect((state) => state)(App);
