import passport from '@plibs/pclientjs/js/passport';
import React from 'react';
import ReactDOM from 'react-dom';
import App from './app.jsx';
import {Provider} from 'react-redux';
import api from '@blocks/api';
import metrics from '@blocks/metrics';
import configureStore from './configureStore';

$(function() {
    const $body = $('body');
    const csrf = $body.data('csrf');
    const initialState = $body.data('locals') || {};

    initialState.common.csrf = csrf;

    const forceInitFields = [
        'firstname',
        'lastname',
        'login',
        'password',
        'password_confirm',
        'phone',
        'hint_answer',
        'captcha'
    ];

    forceInitFields.forEach((fieldName) => {
        const field = document.getElementById(fieldName);

        if (field && field.value) {
            initialState.form.values[fieldName] = field.value;
            initialState.form.states[fieldName] = 'need_validation';
        }
    });

    const store = configureStore(initialState);
    const ExperimentVersion = store.getState().experimentVersion;

    $body.removeAttr('data-locals');

    api.init(store);
    metrics.init(store);
    // monitoring.init(store);

    passport.init();

    ReactDOM.render(
        <Provider store={store}>
            <App />
        </Provider>,
        document.getElementById('root')
    );

    const metricsData = ['регистрация лайтов: показ страницы'];

    if (ExperimentVersion !== undefined) {
        metricsData.push(`версия эксперимента: ${ExperimentVersion}`);
    }
    metrics.send(metricsData);

    /* Logger.init();

    $(window).on('load', function() {
        setTimeout(function() {
            monitoring.send({
                event: 'load'
            });
        }, 0);
    }); */
});
