// технология для borschik, раскрывающая js-файлы с нотацией для ycssjs

var INHERIT = require('borschik/node_modules/inherit'),
    base = require('borschik/lib/tech'),
    FS = require('fs'),
    PATH = require('path');

exports.Tech = INHERIT(base.Tech, {

    minimize: function(content) {
        return require('uglify-js')(content);
    },

    File: exports.File = INHERIT(base.File, {

        parseInclude: function(content) {

            // хитрим, чтобы сделать одни дубликаты на всех
            if (!this.root && this.parent) {
                this.root = this.parent.root;
            }

            if (!this.root) {
                this.root = this;
                this.duplicates = {};
            }

            if (Buffer.isBuffer(content)) {
                content = content.toString('utf8');
            }

            var includes = [];

            const uniqStr = '\00borschik\00';
            var _this = this;

            const allIncRe = /\/\*[\s\S]*?\*\/|include\(['"](.*?)['"]\);/g;

            var texts = content
                .replace(allIncRe, function(_, include) {

                    if (include) {
                        var realPath = _this.pathTo(include);

                        // обрабатываем дубликаты
                        if (realPath in _this.root.duplicates) {
                            console.warn('*** WARNING', realPath + ' was already included in ' + _this.root.duplicates[realPath] + ' and will be skipped.');
                            return '';

                        } else {
                            _this.root.duplicates[realPath] = _this.path
                        }

                        includes.push({
                            file: realPath,
                            type: 'include'
                        });
                    } else {
                        includes.push({
                            file: _,
                            type: 'comment'
                        });
                    }

                    return uniqStr;

                })
                .split(uniqStr);

            // zip texts and includes
            var res = [], t, i;
            while((t = texts.shift()) != null) {
                t && res.push(t);
                (i = includes.shift()) && res.push(i);
            }

            return res;

        },

        processInclude: function(baseFile, content) {
            var parsed = content || this.content;

            var cwd = process.cwd();

            for(var i = 0; i < parsed.length; i++) {
                var item = parsed[i];

                if (typeof item === 'string') {
                    continue;
                }

                if (item.type === 'include') {
                    if(!FS.existsSync(item.file)) {
                        throw new Error('File ' + item.file + ' does not exists, base file is ' + baseFile);
                    }
                    var processed = this.child('include', item.file).process(baseFile);
                    parsed[i] = commentsWrap(processed, PATH.relative(cwd, item.file));

                } else {
                    // комментарии вставляем как есть
                    parsed[i] = item.file;
                }
            }

            return parsed.join('');
        }

    })
});

function commentsWrap(content, file) {
    return '/* ' + file + ': begin */ /**/\n' +
        content +
        '\n/* ' + file + ': end */ /**/\n';

}
