module.exports = function(options) {
    var fs = require('fs');
    var file = fs.readFileSync(options['file'], 'utf-8');
    var json = fs.readFileSync(options['json'], 'utf-8');

    file = file.replace(/yastatic\.net\/mail\/[a-z0-9]+\/[0-9\.]+\/(.*)/g, function(str, url) {
        var freezeRe = new RegExp('"' + url + '":{"url":"(.*?)"');
        var freezeMatch = json.match(freezeRe);
        if (freezeMatch) {
            return 'yastatic.net/mail/neo2/_/' + freezeMatch[1];
        }
        return str;
    });

    fs.writeFileSync(options['file'], file, 'utf-8');
};


function error() {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift('  *** ERROR *** ');
    console.error.apply(console, args);
    printUsage();
}

function printUsage(){
    console.error('\
        \n\
        d2-freeze-urls находит в "file" все ссылки на статические файлы и пытается заменить их на зафриженые урлы из "freeze" \n\
          --file - путь до файла\n\
          --json - путь до результата работы d2-freeze-static\n\
');
    process.exit(1);
}
