var http = require('http');
var url_ = require('url');

var OPTIONS = {};

var VERSIONS = [];
var VERSIONS_URL = 'http://wmiconf.mail.yandex.net/yum-web-log.txt';
var VERSION_RX = /-([0-9.]+)-/;

const pid2package = {
    'jane': 'neo2',
    'mail': 'daria'
};

function getVersions(cb) {
    get(VERSIONS_URL, function(body) {
        parseVersions(body);

        if (VERSIONS.length) {
            cb(VERSIONS);
        } else {
            console.error('*** ERROR ***\nno versions found for ' + OPTIONS.project);
            process.exit(1);
        }
    });
}

function get(url, cb) {
    http.get(url_.parse(url), function(res) {
        var body = '';
        res.setEncoding('utf8');

        res.on('data', function(chunk) {
            body += chunk;
        });

        res.on('end', function() {
            cb(body);
        });
    }).on('error', function(err) {
        console.error(err);
        process.exit(1);
    });
}

function uniq(arr) {
    var obj = {};
    var res = [];

    for (var i = 0, len = arr.length; i < len; i++) {
        var val = arr[i];

        if (!obj[val]) {
            obj[val] = true;
            res.push(val);
        }
    }
    return res;
}

function parseVersions(txt) {
    var package = pid2package[OPTIONS.project];
    var max = OPTIONS.max || 3;
    package = 'verstka_' + package + '-prod';

    var lines = txt.split('\n');
    lines.forEach(function(line) {
        if (line.indexOf(package) > -1) {
            var match = line.match(VERSION_RX);
            if (match) {
                VERSIONS.push(match[1]);
            }
        }
    });

    VERSIONS = uniq(VERSIONS).reverse().slice(0, max);
}

function printUsage(){
    console.error('\
        \n\
        d2-get-old-versions gets old project versions as JSON\n\
          --project - project name\n\
          --max - max versions count (def. 3)\n\
        Example: d2-get-old-versions --project jane --max 2 > some/dir/versions.js\n\
');
    process.exit(1);
}

function error() {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift('  *** ERROR *** ');
    console.error.apply(console, args);
    printUsage();
}

module.exports = function(options) {
    if (!options.project) {
        error('Give me project name!');
    }

    OPTIONS = options;
    getVersions(function(versions) {
        process.stdout.write(JSON.stringify({ versions: versions }));
    });
};
