var fs = require('fs');
var path = require('path');
var exec = require('child_process').exec;

function main(cb) {
    exec("find -L . -mindepth 2 -name '*.wmi.js' -o -name '*.info.js'", function(error, stdout, stderr) {
        if (error) {
            console.error(error);
            console.error(stderr);
            process.exit(1);

        } else {
            var handlers = {};
            stdout
                .split('\n')
                .forEach(function(val) {
                    if (val) {
                        var absPath = path.resolve(val);
                        var baseName = path.basename(absPath, '.js');
                        var split = baseName.split('.');
                        var type = split.slice(-1);
                        var handlerName = split.slice(0, -1).join('.');
                        if (!(handlerName in handlers)) {
                            handlers[handlerName] = {};
                        }

                        handlers[handlerName][type] = absPath;
                    }
                });

            var result = [];
            for (var hName in handlers) {
                var handler = '"' + hName + '":{\n';
                var info = handlers[hName];
                if (!info['wmi']) {
                    console.error('\n\n***ERROR***: Handler.wmi is undefined for "' + info['wmi'] + '"\n\n');
                    process.exit(1);
                }
                handler += '"wmi":' + fs.readFileSync(info['wmi'], 'utf-8').trim();
                if (info['info']) {
                    handler += ',\n"info":' + fs.readFileSync(info['info'], 'utf-8').trim();
                }
                handler += '\n}';
                result.push(handler);
            }

            cb('({\n"__version":"{{VERSION}}",\n' + result.join(',\n') + '\n})');
        }
    })
}

module.exports = main;