var UglifyJS = require("uglify-js");

function LocProcessor(parser, content, extension, entityOpts){
    this.parser = parser;
    this.content = content;
    this.entityOpts = entityOpts || {};

    switch (extension) {
        case '.html':
        case '.js':
        case '.json':
        case '.yate':
            this._processor = this['_' + extension.substr(1)];
            break;

        default:
            throw 'Sorry, I do not know how to localize file "' + extension + '"';
    }
}

LocProcessor.prototype = {

    process: function() {
        return this._processor();
    },

    _yate: function() {

        try {
            var originalAST = UglifyJS.parse(this.content);
        } catch(e) {
            console.error('Cant parse js file');
            throw e;
        }

        var tt = new UglifyJS.TreeTransformer(null, function(node){
            if (itIsCall(node, 'i18n')) {
                return this._getTargetAST(node.args, true);

            } else if (itIsCall(node, 'i18n_unsafe')) {
                return this._getTargetAST(node.args);

            } else if (this.entityOpts.entity && itIsCall(node, 'entity')) {
                var entity = node.args[0].value;
                if (entity in this.entityOpts.entity) {
                    return new UglifyJS.AST_String({value: this.entityOpts.entity[entity]});

                } else if (!this.entityOpts['ignore-undefined-entity']) {
                    console.error('Entity "' + entity + '" is undefined');
                    process.exit(1);
                }
            }
            return node;
        }.bind(this));

        return originalAST.transform(tt);
    },

    _json: function() {
        return this.content.replace(/i18n\((?:'|")%(.*?)(?:'|")\)/g, function(match, key) {
            // в html никакой обработки, можно просто вернуть оригинальный ключ
            return JSON.stringify(this.parser.ORIGINAl_KEYS[key]);
        }.bind(this));
    },

    _html: function() {
        return this.content.replace(/&i18n_(.*?);/g, function(match, key) {
            // в html никакой обработки, можно просто вернуть оригинальный ключ
            return this.parser.ORIGINAl_KEYS[key];
        }.bind(this));
    },

    _js: function() {
        try {
            var originalAST = UglifyJS.parse(this.content);
        } catch(e) {
            console.error('Cant parse js file');
            throw e;
        }

        var tt = new UglifyJS.TreeTransformer(null, function(node){
            if (node instanceof UglifyJS.AST_Call && node.expression.name == 'i18n') {
                return this._getTargetAST(node.args);
            }
            return node;
        }.bind(this));

        return originalAST.transform(tt);
    },

    _getTargetAST: function(args, entitify) {
        var key = args.slice(0, 1)[0].value.substr(1);
        var keyVal = this.parser.getKeyAST(key);
        try {
            if (entitify) {
                for (var i = 0; i < args.length; i++) {
                    var arg = args[i];
                    if (!(arg instanceof UglifyJS.AST_String)) {
                        args[i] = new UglifyJS.AST_Call({
                            args: [arg],
                            expression: new UglifyJS.AST_Dot({
                                property: 'entityify',
                                expression: new UglifyJS.AST_Dot({
                                    property: 'externals',
                                    expression: new UglifyJS.AST_SymbolRef({
                                        name: 'yr'
                                    })
                                })
                            })
                        });
                    }
                }
            }

            // копируем ast и заменяем аргументы
            return this.parser.deepASTCopy(keyVal.ast, args.slice(1));
        } catch(e) {
            console.error('Key "%' + key + '"');
            throw e;
        }
    }
};

function itIsCall(node, name) {
    return node instanceof UglifyJS.AST_Call &&
        (
            node.expression.name == name ||
            node.expression.property == name ||
            (node.expression.property && node.expression.property.value == name)
        )
}

module.exports = LocProcessor;
