var fs = require('fs');
var path = require('path');

var OPTIONS = {};
const VERSION_SEPARATOR = '@';

/**
 * Проверяет существование папки.
 * @param dir
 * @return {*}
 */
function checkIfDirExists(dir) {
    if (!fs.existsSync(dir)) {
        error('Director "'+ dir +'" is not exists!');
    }
}

function printUsage(){
    console.error('\
        \n\
        d2-merge-patches merge project patches\n\
          --versions - path to old versions JSON file\n\
          --project - path to project dir\n\
          --lang - locale\n\
        Example: d2-merge-patches --project diff/jane --versions _versions.json --lang ru\n\
');
    process.exit(1);
}

function error() {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift('  *** ERROR *** ');
    console.error.apply(console, args);
    printUsage();
}

function mergePatches() {
    var versions = require(OPTIONS.versions).versions;
    var files = fs.readdirSync(OPTIONS.project);

    versions.forEach(function(version) {
        mergeByVersion(version, files.filter(function(file) {
            return file.indexOf(version + VERSION_SEPARATOR) == 0;
        }));
    });
}

function mergeByVersion(version, files) {
    var data = {
        '.css': [],
        '.yate': [],
        '.js': []
    };
    var lang = OPTIONS.lang;
    var projectDir = OPTIONS.project;
    var pid = path.basename(projectDir);
    var outputDir = path.dirname(projectDir);

    files.forEach(function(file) {
        var ext = path.extname(path.basename(file, path.extname(file)));

        if (data[ext]) {
            if (ext == '.css' || file.indexOf('.' + lang + '.') > 0) {
                data[ext].push(file);
            };
        }
    });

    data['.css'].forEach(function(theme) {
        var output = [JSON.parse(fs.readFileSync(path.join(projectDir, theme), 'utf-8'))];

        data['.js'].concat(data['.yate']).forEach(function(js) {
            output.push(JSON.parse(fs.readFileSync(path.join(projectDir, js), 'utf-8')));
        });

        var filePath = path.join(outputDir, pid + '.' + version + VERSION_SEPARATOR + getThemeName(theme) + '.' + lang + '.js');
        fs.writeFileSync(filePath, JSON.stringify(output), 'utf-8');
    });
}

function getThemeName(theme) {
    var nameParts = theme.split(VERSION_SEPARATOR)[1];
    nameParts = nameParts.split('.');
    return nameParts[0];
}

module.exports = function(options) {
    if (!options.versions) {
        error('Give me path to old versions file!');
    }

    if (!options.lang) {
        error('Give me lang!');
    }

    if (!options.project) {
        error('Give me project dir!');
    }

    OPTIONS = options;
    checkIfDirExists(options.project);
    mergePatches();
};
