module.exports = {
    freezeStatic: require('./lib/d2-freeze-static.js'),
    freezeStatic2: require('./lib/d2-freeze-static2.js'),
    freezeUrls: require('./lib/d2-freeze-urls.js'),
    gzip: require('./lib/d2-gzip'),
    handlers: require('./lib/d2-handlers.js'),
    ipv6ize: require('./lib/d2-ipv6ize'),
    localize: require('./lib/d2-localize.js'),
    makePatch: require('./lib/d2-make-patch.js'),
    mergePatches: require('./lib/d2-merge-patches.js'),
    getOldVersions: require('./lib/d2-get-old-versions.js'),
    uglify: function(processedAST, parsed) {
        var UglifyJS = require('uglify-js');
        if (typeof processedAST === 'string') {
            processedAST = UglifyJS.parse(processedAST);
        }

        if (parsed['minimize']) {
            processedAST.figure_out_scope();
            processedAST = processedAST.transform(UglifyJS.Compressor({
                sequences: false,
                warnings: parsed['uglify-warnings']
            }));
            processedAST.figure_out_scope();
            processedAST.compute_char_frequency();
            processedAST.mangle_names({});
        }

        var printParams = {
            beautify: !parsed['minimize'],
            max_line_len: parsed['max-line-len']
        };

        // сохраняем комментарии, если не минимизируем файлы
        if (!parsed['minimize']) {
            printParams['comments'] = 'all';
        }

        return processedAST.print_to_string(printParams);
    }
};
