'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
exports.Account = void 0;

var _react = _interopRequireDefault(require('react'));

var _propTypes = _interopRequireDefault(require('prop-types'));

var _config = require('./config');

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

function _typeof(obj) {
    '@babel/helpers - typeof';
    if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
        _typeof = function _typeof(obj) {
            return typeof obj;
        };
    } else {
        _typeof = function _typeof(obj) {
            return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype
                ? 'symbol'
                : typeof obj;
        };
    }
    return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function');
    }
}

function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];

        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ('value' in descriptor) {
            descriptor.writable = true;
        }
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}

function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) {
        _defineProperties(Constructor.prototype, protoProps);
    }
    if (staticProps) {
        _defineProperties(Constructor, staticProps);
    }
    return Constructor;
}

function _inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
        throw new TypeError('Super expression must either be null or a function');
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {value: subClass, writable: true, configurable: true}
    });
    if (superClass) {
        _setPrototypeOf(subClass, superClass);
    }
}

function _setPrototypeOf(o, p) {
    _setPrototypeOf =
        Object.setPrototypeOf ||
        function _setPrototypeOf(o, p) {
            o.__proto__ = p;
            return o;
        };
    return _setPrototypeOf(o, p);
}

function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived),
            result;

        if (hasNativeReflectConstruct) {
            var NewTarget = _getPrototypeOf(this).constructor;

            result = Reflect.construct(Super, arguments, NewTarget);
        } else {
            result = Super.apply(this, arguments);
        }
        return _possibleConstructorReturn(this, result);
    };
}

function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
        return call;
    }
    return _assertThisInitialized(self);
}

function _assertThisInitialized(self) {
    if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
}

function _isNativeReflectConstruct() {
    if (typeof Reflect === 'undefined' || !Reflect.construct) {
        return false;
    }
    if (Reflect.construct.sham) {
        return false;
    }
    if (typeof Proxy === 'function') {
        return true;
    }
    try {
        Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
        return true;
    } catch (e) {
        return false;
    }
}

function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf
        ? Object.getPrototypeOf
        : function _getPrototypeOf(o) {
              return o.__proto__ || Object.getPrototypeOf(o);
          };
    return _getPrototypeOf(o);
}

var Account = /*#__PURE__*/ (function(_React$Component) {
    _inherits(Account, _React$Component);

    var _super = _createSuper(Account);

    function Account() {
        _classCallCheck(this, Account);

        return _super.apply(this, arguments);
    }

    _createClass(Account, [
        {
            key: 'getChangeDefaultUrl',
            value: function getChangeDefaultUrl() {
                var _this$props = this.props,
                    changeDefaultUrl = _this$props.changeDefaultUrl,
                    uid = _this$props.uid;

                return changeDefaultUrl ? ''.concat(changeDefaultUrl, '&uid=').concat(uid) : '';
            }
        },
        {
            key: 'render',
            value: function render() {
                var _this$props2 = this.props,
                    mail = _this$props2.mail,
                    login = _this$props2.login,
                    name = _this$props2.name,
                    avatarId = _this$props2.avatarId,
                    avatarHost = _this$props2.avatarHost;
                var displayName = mail || login || name || '';
                var href = this.getChangeDefaultUrl();
                var avatarStyle = {
                    backgroundImage: 'url("'.concat((0, _config.avatarURL)(avatarHost, avatarId, 'small'), '")')
                };

                return /*#__PURE__*/ _react.default.createElement(
                    'li',
                    null,
                    displayName &&
                        /*#__PURE__*/ _react.default.createElement(
                            'a',
                            {
                                className: 'dheader-account',
                                href: href
                            },
                            /*#__PURE__*/ _react.default.createElement('span', {
                                className: 'dheader-account-avatar',
                                style: avatarStyle
                            }),
                            /*#__PURE__*/ _react.default.createElement(
                                'span',
                                {
                                    className: 'dheader-account-name__firstletter'
                                },
                                displayName.charAt(0)
                            ),
                            displayName.substr(1)
                        )
                );
            }
        }
    ]);

    return Account;
})(_react.default.Component);

exports.Account = Account;
Account.propTypes = {
    mail: _propTypes.default.string,
    login: _propTypes.default.string.isRequired,
    avatarId: _propTypes.default.string.isRequired,
    name: _propTypes.default.string,
    changeDefaultUrl: _propTypes.default.string.isRequired,
    uid: _propTypes.default.string.isRequired,
    avatarHost: _propTypes.default.string.isRequired
};
