'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
exports.Accounts = void 0;

var _react = _interopRequireDefault(require('react'));

var _propTypes = _interopRequireDefault(require('prop-types'));

var _account = require('./account');

var _config = require('./config');

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

function _typeof(obj) {
    '@babel/helpers - typeof';
    if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
        _typeof = function _typeof(obj) {
            return typeof obj;
        };
    } else {
        _typeof = function _typeof(obj) {
            return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype
                ? 'symbol'
                : typeof obj;
        };
    }
    return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function');
    }
}

function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];

        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ('value' in descriptor) {
            descriptor.writable = true;
        }
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}

function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) {
        _defineProperties(Constructor.prototype, protoProps);
    }
    if (staticProps) {
        _defineProperties(Constructor, staticProps);
    }
    return Constructor;
}

function _inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
        throw new TypeError('Super expression must either be null or a function');
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {value: subClass, writable: true, configurable: true}
    });
    if (superClass) {
        _setPrototypeOf(subClass, superClass);
    }
}

function _setPrototypeOf(o, p) {
    _setPrototypeOf =
        Object.setPrototypeOf ||
        function _setPrototypeOf(o, p) {
            o.__proto__ = p;
            return o;
        };
    return _setPrototypeOf(o, p);
}

function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived),
            result;

        if (hasNativeReflectConstruct) {
            var NewTarget = _getPrototypeOf(this).constructor;

            result = Reflect.construct(Super, arguments, NewTarget);
        } else {
            result = Super.apply(this, arguments);
        }
        return _possibleConstructorReturn(this, result);
    };
}

function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
        return call;
    }
    return _assertThisInitialized(self);
}

function _assertThisInitialized(self) {
    if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
}

function _isNativeReflectConstruct() {
    if (typeof Reflect === 'undefined' || !Reflect.construct) {
        return false;
    }
    if (Reflect.construct.sham) {
        return false;
    }
    if (typeof Proxy === 'function') {
        return true;
    }
    try {
        Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
        return true;
    } catch (e) {
        return false;
    }
}

function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf
        ? Object.getPrototypeOf
        : function _getPrototypeOf(o) {
              return o.__proto__ || Object.getPrototypeOf(o);
          };
    return _getPrototypeOf(o);
}

var Accounts = /*#__PURE__*/ (function(_React$Component) {
    _inherits(Accounts, _React$Component);

    var _super = _createSuper(Accounts);

    function Accounts() {
        _classCallCheck(this, Accounts);

        return _super.apply(this, arguments);
    }

    _createClass(Accounts, [
        {
            key: 'getChangeDefaultUrl',
            value: function getChangeDefaultUrl() {
                var props = this.props;

                var changeDefaultUrl = _config.links.embeddedauth(props.tld);

                ['action', 'yu', 'ci', 'retpath'].forEach(function(key) {
                    changeDefaultUrl += '&';
                    changeDefaultUrl += key;
                    changeDefaultUrl += '=';

                    if (key === 'action') {
                        changeDefaultUrl += 'change_default';
                    } else if (key === 'retpath') {
                        changeDefaultUrl += encodeURIComponent(props.currentURL);
                    } else {
                        changeDefaultUrl += encodeURIComponent(props[key]) || '';
                    }
                });
                return changeDefaultUrl;
            }
        },
        {
            key: 'getAddAccountView',
            value: function getAddAccountView() {
                var _this$props = this.props,
                    accounts = _this$props.accounts,
                    tld = _this$props.tld,
                    currentURL = _this$props.currentURL,
                    language = _this$props.language;
                var canAddMore = accounts.length < 15,
                    i18nObj = _config.i18n[language] || _config.i18n.default;

                if (!canAddMore) {
                    return null;
                }

                return /*#__PURE__*/ _react.default.createElement(
                    'a',
                    {
                        className: 'dheader-account dheader-account__add',
                        href: _config.links.auth(tld, currentURL, 'add-user')
                    },
                    /*#__PURE__*/ _react.default.createElement('span', {
                        className: 'dheader-account-avatar dheader-account-avatar__add'
                    }),
                    i18nObj.addAccount
                );
            }
        },
        {
            key: 'getSubMenuOptions',
            value: function getSubMenuOptions() {
                var _this$props2 = this.props,
                    language = _this$props2.language,
                    yu = _this$props2.yu,
                    currentURL = _this$props2.currentURL,
                    tld = _this$props2.tld,
                    i18nObj = _config.i18n[language] || _config.i18n.default,
                    ci = _this$props2.ci;

                return [
                    {
                        text: i18nObj.tune,
                        url: _config.links.tune(tld)
                    },
                    {
                        text: i18nObj.exit,
                        url: _config.links.logout(tld, currentURL, yu, ci)
                    }
                ];
            }
        },
        {
            key: 'render',
            value: function render() {
                var _this$props3 = this.props,
                    accounts = _this$props3.accounts,
                    avatarHost = _this$props3.avatarHost;
                var changeDefaultUrl = this.getChangeDefaultUrl();
                var subMenuOptions = this.getSubMenuOptions();

                return /*#__PURE__*/ _react.default.createElement(
                    'div',
                    null,
                    /*#__PURE__*/ _react.default.createElement(
                        'ul',
                        {
                            className: 'dheader-accounts'
                        },
                        accounts &&
                            accounts.length > 1 &&
                            accounts.map(function(account) {
                                return /*#__PURE__*/ _react.default.createElement(_account.Account, {
                                    key: account.uid,
                                    mail: account.mail,
                                    login: account.login,
                                    avatarId: account.avatarId,
                                    uid: account.uid,
                                    changeDefaultUrl: changeDefaultUrl,
                                    name: account.displayName,
                                    avatarHost: avatarHost
                                });
                            }),
                        this.getAddAccountView()
                    ),
                    /*#__PURE__*/ _react.default.createElement(
                        'ul',
                        {
                            className: 'dheader-menu'
                        },
                        subMenuOptions.map(function(item) {
                            return /*#__PURE__*/ _react.default.createElement(
                                'li',
                                {
                                    key: item.url,
                                    className: 'dheader-menu__list-item'
                                },
                                /*#__PURE__*/ _react.default.createElement(
                                    'a',
                                    {
                                        href: item.url,
                                        className: 'dheader-menu__link-item'
                                    },
                                    item.text
                                )
                            );
                        })
                    )
                );
            }
        }
    ]);

    return Accounts;
})(_react.default.Component);

exports.Accounts = Accounts;
Accounts.propTypes = {
    accounts: _propTypes.default.arrayOf(_propTypes.default.object),
    yu: _propTypes.default.string.isRequired,
    currentURL: _propTypes.default.string.isRequired,
    tld: _propTypes.default.string.isRequired,
    language: _propTypes.default.string.isRequired,
    avatarHost: _propTypes.default.string.isRequired,
    ci: _propTypes.default.string.isRequired
};
