'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
exports.i18n = exports.navigation = exports.avatarURL = exports.links = void 0;

var _react = _interopRequireDefault(require('react'));

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

var links = {
    embeddedauth: function embeddedauth() {
        return ''.concat(links.host, '/passport?mode=embeddedauth');
    },
    logout: function logout(tld, url, yu, ci) {
        return ''
            .concat(links.host, '/passport?mode=logout')
            .concat('&ci=', ci)
            .concat('&yu=', yu)
            .concat('&retpath=', encodeURIComponent(url));
    },
    auth: function auth(tld, url, mode) {
        var link = ''.concat(links.host, '/auth?retpath=').concat(encodeURIComponent(url));

        return mode ? ''.concat(link, '&mode=').concat(mode) : link;
    },
    tune: function tune(tld) {
        return 'https://tune.yandex.'.concat(tld || 'ru');
    },
    yandex: function yandex(tld) {
        return 'https://yandex.'.concat(tld || 'ru');
    },
    passport: function passport() {
        return ''.concat(links.host);
    }
};

exports.links = links;

var avatarURL = function avatarURL(host, uid, size) {
    return 'https://'
        .concat(host, '/get-yapic/')
        .concat(uid || '0/0-0', '/islands-')
        .concat(size);
};

exports.avatarURL = avatarURL;

var navigation = function navigation(host) {
    var tld = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'ru';

    return [
        {
            key: 'profile',
            url: ''.concat(host, '/profile')
        },
        {
            key: 'subscriptions',
            url: ''.concat(host, '/profile/subscriptions')
        },
        {
            key: 'services',
            url: ''.concat(host, '/profile/services')
        },
        {
            key: 'ugc',
            url: 'https://yandex.'.concat(tld, '/ugcpub/cabinet')
        },
        {
            key: 'loyalty',
            url: 'https://yandex.'.concat(tld, '/loyalty-program')
        }
    ];
};

exports.navigation = navigation;
var i18n = {
    default: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: 'Account management',
        services: 'My services',
        ugc: 'Reviews and ratings',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    ru: {
        addAccount: 'Добавить пользователя',
        tune: 'Настроить',
        exit: 'Выход',
        profile: 'Управление аккаунтом',
        services: 'Мои сервисы',
        ugc: 'Отзывы и оценки',
        loyalty:
            /*#__PURE__*/
            // eslint-disable-line no-extra-parens
            _react.default.createElement(
                'div',
                null,
                /*#__PURE__*/ _react.default.createElement(
                    'span',
                    null,
                    '\u041C\u043E\u0438 \u043A\u0430\u0440\u0442\u044B \u043B\u043E\u044F\u043B\u044C\u043D\u043E\u0441\u0442\u0438'
                ),
                ' ',
                /*#__PURE__*/ _react.default.createElement(
                    'sup',
                    {
                        className: 'beta'
                    },
                    '\u0411\u0435\u0442\u0430'
                )
            ),
        subscriptions: 'Подписки'
    },
    kk: {
        addAccount: 'Пайдаланушыны қосу',
        tune: 'Баптау',
        exit: 'Шығу',
        profile: 'Аккаунтты басқару',
        services: 'Менің қызметтерім',
        ugc: 'Пікірлер мен бағалаулар',
        loyalty: '',
        subscriptions: 'Жазылымдар'
    },
    uz: {
        addAccount: 'Foydalanuvchi qoʻshish',
        tune: 'Sozlash',
        exit: 'Chiqish',
        profile: 'Hisobni boshqarish',
        services: 'Xizmatlarim',
        ugc: 'Fikrlar va baholar',
        loyalty: '',
        subscriptions: 'Obunalar'
    },
    en: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: 'Account management',
        services: 'My services',
        ugc: 'Reviews and ratings',
        loyalty:
            /*#__PURE__*/
            // eslint-disable-line no-extra-parens
            _react.default.createElement(
                'div',
                null,
                /*#__PURE__*/ _react.default.createElement('span', null, 'My loyalty cards'),
                ' ',
                /*#__PURE__*/ _react.default.createElement(
                    'sup',
                    {
                        className: 'color_red'
                    },
                    'Beta'
                )
            ),
        subscriptions: 'Subscriptions'
    },
    pt: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: 'Account management',
        services: 'My services',
        ugc: 'Reviews and ratings',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    ky: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: 'Account management',
        services: 'My services',
        ugc: 'Reviews and ratings',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    uk: {
        addAccount: 'Додати користувача',
        tune: 'Налаштувати',
        exit: 'Вихід',
        profile: 'Керування акаунтом',
        services: 'Мої сервіси',
        ugc: 'Відгуки й оцінки',
        loyalty: 'Мої карти лояльності',
        subscriptions: 'Підписки'
    },
    fr: {
        addAccount: 'Ajouter un utilisateur',
        tune: 'Paramétrer',
        exit: 'Déconnexion',
        profile: '',
        services: '',
        ugc: '',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    tr: {
        addAccount: 'Yeni kullanıcı ekle',
        tune: 'Ayarla',
        exit: 'Çıkış',
        profile: 'Hesap yönetimi',
        services: 'Servislerim',
        ugc: 'Yorumlar ve değerlendirmeler',
        loyalty: 'İndirim kartlarım',
        subscriptions: 'Aboneler'
    },
    fi: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: '',
        services: '',
        ugc: '',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    id: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: '',
        services: '',
        ugc: '',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    az: {
        addAccount: 'İstifadəçi əlavə et',
        tune: 'Qur',
        exit: 'Siyahıdan çıxar',
        profile: '',
        services: '',
        ugc: '',
        loyalty: '',
        subscriptions: 'Subscriptions'
    },
    he: {
        addAccount: 'Add account',
        tune: 'Configure',
        exit: 'Log out',
        profile: 'Account management',
        services: 'My services',
        ugc: 'Reviews and ratings',
        loyalty: '',
        subscriptions: 'Subscriptions'
    }
};

exports.i18n = i18n;
