'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
exports.Header = void 0;

var _react = _interopRequireDefault(require('react'));

var _propTypes = _interopRequireDefault(require('prop-types'));

var _logo = require('./logo');

var _navigation = require('./navigation');

var _accounts = require('./accounts');

var _config = require('./config');

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

function _typeof(obj) {
    '@babel/helpers - typeof';
    if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
        _typeof = function _typeof(obj) {
            return typeof obj;
        };
    } else {
        _typeof = function _typeof(obj) {
            return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype
                ? 'symbol'
                : typeof obj;
        };
    }
    return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function');
    }
}

function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];

        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ('value' in descriptor) {
            descriptor.writable = true;
        }
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}

function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) {
        _defineProperties(Constructor.prototype, protoProps);
    }
    if (staticProps) {
        _defineProperties(Constructor, staticProps);
    }
    return Constructor;
}

function _inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
        throw new TypeError('Super expression must either be null or a function');
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {value: subClass, writable: true, configurable: true}
    });
    if (superClass) {
        _setPrototypeOf(subClass, superClass);
    }
}

function _setPrototypeOf(o, p) {
    _setPrototypeOf =
        Object.setPrototypeOf ||
        function _setPrototypeOf(o, p) {
            o.__proto__ = p;
            return o;
        };
    return _setPrototypeOf(o, p);
}

function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived),
            result;

        if (hasNativeReflectConstruct) {
            var NewTarget = _getPrototypeOf(this).constructor;

            result = Reflect.construct(Super, arguments, NewTarget);
        } else {
            result = Super.apply(this, arguments);
        }
        return _possibleConstructorReturn(this, result);
    };
}

function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
        return call;
    }
    return _assertThisInitialized(self);
}

function _assertThisInitialized(self) {
    if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
}

function _isNativeReflectConstruct() {
    if (typeof Reflect === 'undefined' || !Reflect.construct) {
        return false;
    }
    if (Reflect.construct.sham) {
        return false;
    }
    if (typeof Proxy === 'function') {
        return true;
    }
    try {
        Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
        return true;
    } catch (e) {
        return false;
    }
}

function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf
        ? Object.getPrototypeOf
        : function _getPrototypeOf(o) {
              return o.__proto__ || Object.getPrototypeOf(o);
          };
    return _getPrototypeOf(o);
}

var shape = _propTypes.default.shape({
    uid: _propTypes.default.string.isRequired,
    displayName: _propTypes.default.string,
    avatarId: _propTypes.default.string.isRequired,
    login: _propTypes.default.string.isRequired,
    mail: _propTypes.default.string
});

var Header = /*#__PURE__*/ (function(_React$Component) {
    _inherits(Header, _React$Component);

    var _super = _createSuper(Header);

    function Header(props) {
        var _this;

        _classCallCheck(this, Header);

        _this = _super.call(this, props);
        var _props$passportHost = props.passportHost,
            passportHost = _props$passportHost === void 0 ? '' : _props$passportHost,
            _props$tld = props.tld,
            tld = _props$tld === void 0 ? 'ru' : _props$tld;

        _config.links.host = passportHost.replace('%tld%', tld) || 'https://passport.yandex.'.concat(tld);
        return _this;
    }

    _createClass(Header, [
        {
            key: 'getSplittedDisplayName',
            value: function getSplittedDisplayName() {
                var currentAccount = this.props.currentAccount;
                var regexCodePoint = /[^\uD800-\uDFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDFFF]/g;
                var match = currentAccount.displayName && currentAccount.displayName.match(regexCodePoint);
                var result = {};

                if (match) {
                    result.head = match[0];
                    result.tail = match.slice(1).join('');
                }

                return result;
            }
        },
        {
            key: 'render',
            value: function render() {
                var _this$props = this.props,
                    currentURL = _this$props.currentURL,
                    language = _this$props.language,
                    yandexUID = _this$props.yandexUID,
                    accounts = _this$props.accounts,
                    activeLinkID = _this$props.activeLinkID,
                    currentAccount = _this$props.currentAccount,
                    avatarHost = _this$props.avatarHost,
                    tld = _this$props.tld,
                    onlyKUBR = _this$props.onlyKUBR,
                    showLoyalty = _this$props.showLoyalty,
                    showSubscriptions = _this$props.showSubscriptions,
                    ci = _this$props.ci;
                var splittedDisplayName = this.getSplittedDisplayName();
                var avatarStyle = {
                    backgroundImage: 'url("'.concat(
                        (0, _config.avatarURL)(avatarHost, currentAccount.avatarId, '50'),
                        '")'
                    )
                };

                return /*#__PURE__*/ _react.default.createElement(
                    'div',
                    {
                        className: 'dheader'
                    },
                    /*#__PURE__*/ _react.default.createElement(
                        'a',
                        {
                            href: _config.links.auth(tld, currentURL),
                            className: 'dheader-user'
                        },
                        /*#__PURE__*/ _react.default.createElement(
                            'span',
                            {
                                className: 'dheader-user-avatar',
                                style: avatarStyle
                            },
                            /*#__PURE__*/ _react.default.createElement('span', {
                                className: 'dheader-user-avatar-mask'
                            })
                        ),
                        /*#__PURE__*/ _react.default.createElement(
                            'span',
                            {
                                className: 'dheader-user-displayname'
                            },
                            /*#__PURE__*/ _react.default.createElement(
                                'span',
                                {
                                    className: 'dheader-user-displayname__firstletter'
                                },
                                splittedDisplayName.head
                            ),
                            /*#__PURE__*/ _react.default.createElement(
                                'span',
                                {
                                    'data-t': 'dheader-user-displayname:tail'
                                },
                                splittedDisplayName.tail
                            )
                        )
                    ),
                    /*#__PURE__*/ _react.default.createElement(
                        'div',
                        {
                            className: 'dheader-user__mobile'
                        },
                        currentAccount.mail
                    ),
                    /*#__PURE__*/ _react.default.createElement(
                        'div',
                        {
                            className: 'dheader-popup'
                        },
                        /*#__PURE__*/ _react.default.createElement(_accounts.Accounts, {
                            yu: yandexUID,
                            accounts: accounts,
                            currentURL: currentURL,
                            tld: tld,
                            language: language,
                            avatarHost: avatarHost,
                            ci
                        })
                    ),
                    /*#__PURE__*/ _react.default.createElement(_logo.Logo, {
                        language: language,
                        tld: tld
                    }),
                    /*#__PURE__*/ _react.default.createElement(_navigation.Navigation, {
                        tld: tld,
                        activeLinkID: activeLinkID,
                        navigation: (0, _config.navigation)(_config.links.host, tld),
                        onlyKUBR: onlyKUBR,
                        showLoyalty: showLoyalty,
                        showSubscriptions: showSubscriptions,
                        lang: language
                    })
                );
            }
        }
    ]);

    return Header;
})(_react.default.Component);

exports.Header = Header;
Header.propTypes = {
    language: _propTypes.default.string.isRequired,
    yandexUID: _propTypes.default.string.isRequired,
    accounts: _propTypes.default.arrayOf(shape).isRequired,
    currentAccount: shape.isRequired,
    currentURL: _propTypes.default.string.isRequired,
    tld: _propTypes.default.string.isRequired,
    activeLinkID: _propTypes.default.number,
    avatarHost: _propTypes.default.string,
    passportHost: _propTypes.default.string,
    onlyKUBR: _propTypes.default.bool,
    showLoyalty: _propTypes.default.bool,
    ci: _propTypes.default.string.isRequired
};
