'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
exports.Logo = Logo;

var _react = _interopRequireDefault(require('react'));

var _propTypes = _interopRequireDefault(require('prop-types'));

var _classnames = _interopRequireDefault(require('classnames'));

var _config = require('./config');

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

function Logo(_ref) {
    var language = _ref.language,
        tld = _ref.tld;
    var isRu = ['ru', 'uk'].indexOf(language) !== -1;

    return _react.default.createElement(
        'span',
        {
            className: 'dheader-logo_container'
        },
        _react.default.createElement('a', {
            href: _config.links.yandex(tld),
            className: (0, _classnames.default)({
                'dheader-logo_ya': true,
                'dheader-logo_ya_ru': isRu,
                'dheader-logo_ya_en': !isRu
            })
        }),
        _react.default.createElement('a', {
            href: _config.links.passport(tld),
            className: (0, _classnames.default)({
                'dheader-logo_id': true
            })
        })
    );
}

Logo.propTypes = {
    language: _propTypes.default.string.isRequired,
    tld: _propTypes.default.string.isRequired
};
