'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
exports.Navigation = void 0;

var _react = _interopRequireDefault(require('react'));

var _propTypes = _interopRequireDefault(require('prop-types'));

var _classnames = _interopRequireDefault(require('classnames'));

var _config = require('./config');

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

function _typeof(obj) {
    '@babel/helpers - typeof';
    if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
        _typeof = function _typeof(obj) {
            return typeof obj;
        };
    } else {
        _typeof = function _typeof(obj) {
            return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype
                ? 'symbol'
                : typeof obj;
        };
    }
    return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function');
    }
}

function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];

        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ('value' in descriptor) {
            descriptor.writable = true;
        }
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}

function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) {
        _defineProperties(Constructor.prototype, protoProps);
    }
    if (staticProps) {
        _defineProperties(Constructor, staticProps);
    }
    return Constructor;
}

function _inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
        throw new TypeError('Super expression must either be null or a function');
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {value: subClass, writable: true, configurable: true}
    });
    if (superClass) {
        _setPrototypeOf(subClass, superClass);
    }
}

function _setPrototypeOf(o, p) {
    _setPrototypeOf =
        Object.setPrototypeOf ||
        function _setPrototypeOf(o, p) {
            o.__proto__ = p;
            return o;
        };
    return _setPrototypeOf(o, p);
}

function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived),
            result;

        if (hasNativeReflectConstruct) {
            var NewTarget = _getPrototypeOf(this).constructor;

            result = Reflect.construct(Super, arguments, NewTarget);
        } else {
            result = Super.apply(this, arguments);
        }
        return _possibleConstructorReturn(this, result);
    };
}

function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
        return call;
    }
    return _assertThisInitialized(self);
}

function _assertThisInitialized(self) {
    if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
}

function _isNativeReflectConstruct() {
    if (typeof Reflect === 'undefined' || !Reflect.construct) {
        return false;
    }
    if (Reflect.construct.sham) {
        return false;
    }
    if (typeof Proxy === 'function') {
        return true;
    }
    try {
        Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
        return true;
    } catch (e) {
        return false;
    }
}

function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf
        ? Object.getPrototypeOf
        : function _getPrototypeOf(o) {
              return o.__proto__ || Object.getPrototypeOf(o);
          };
    return _getPrototypeOf(o);
}

var Navigation = /*#__PURE__*/ (function(_React$Component) {
    _inherits(Navigation, _React$Component);

    var _super = _createSuper(Navigation);

    _createClass(Navigation, null, [
        {
            key: 'correctNav',
            value: function correctNav(props) {
                var navigation = props.navigation,
                    onlyKUBR = props.onlyKUBR,
                    showLoyalty = props.showLoyalty,
                    tld = props.tld,
                    showSubscriptions = props.showSubscriptions;
                var nav = [navigation[0]];

                if (showSubscriptions) {
                    nav.push(navigation[1]);
                }

                if (!onlyKUBR || (onlyKUBR && ['kz', 'ua', 'by', 'ru'].indexOf(tld) !== -1)) {
                    nav.push(navigation[2]);
                }

                if (tld === 'ru') {
                    nav.push(navigation[3]);
                }

                if (showLoyalty) {
                    nav.push(navigation[4]);
                }

                return nav;
            }
        }
    ]);

    function Navigation(props) {
        var _this;

        _classCallCheck(this, Navigation);

        _this = _super.call(this, props);
        _this.state = {
            dummy: false
        };
        _this.nav = Navigation.correctNav(props);
        return _this;
    }

    _createClass(Navigation, [
        {
            key: 'render',
            value: function render() {
                var _this$props = this.props,
                    activeLinkID = _this$props.activeLinkID,
                    lang = _this$props.lang;

                return /*#__PURE__*/ _react.default.createElement(
                    'div',
                    {
                        className: 'dheader-navigation'
                    },
                    /*#__PURE__*/ _react.default.createElement(
                        'div',
                        {
                            className: 'dheader-navigation__inner',
                            ref: 'scroller'
                        },
                        this.nav.map(function(item, index) {
                            return /*#__PURE__*/ _react.default.createElement(
                                'a',
                                {
                                    key: index,
                                    href: item.url,
                                    'data-t': 'dheader-nav:native',
                                    className: (0, _classnames.default)('dheader-navigation-item', {
                                        'dheader-navigation-item__active': index === activeLinkID
                                    })
                                },
                                (_config.i18n[lang] && _config.i18n[lang][item.key]) || _config.i18n.default[item.key]
                            );
                        })
                    )
                );
            }
        }
    ]);

    return Navigation;
})(_react.default.Component);

exports.Navigation = Navigation;
Navigation.propTypes = {
    activeLinkID: _propTypes.default.number,
    navigation: _propTypes.default.arrayOf(
        _propTypes.default.shape({
            key: _propTypes.default.string.isRequired,
            url: _propTypes.default.string.isRequired
        })
    ).isRequired,
    tld: _propTypes.default.string.isRequired,
    onlyKUBR: _propTypes.default.bool,
    showLoyalty: _propTypes.default.bool,
    lang: _propTypes.default.string.isRequired
};
