const orderFragment = `
    fragment orderFragment on Order {
        id
        date
        name
        passed
        ticketsPdf {
            url
        }
        ticketsCount
        place {
            title
            url(domain: true)
        }
        event {
            id
            url(domain: true)
            title
            image {
                image(size: s544x312_crop) {
                    url
                }
            }
        }
    }
`;

const favoriteEventFragment = `
    fragment favoriteEventFragment on ActualEvent {
        event {
            url(domain: true)
            image {
                image(size: s544x312_crop) {
                    url        
                }
            }
            title
            originalTitle
            type {
                name
            }
        }
        scheduleInfo {
            dateStarted
            dateEnd
            onlyPlace {
                title
                url(domain: true)
            }
            placePreview
            placesTotal 
            preview(short: false) {
                type
                text
                
            }
        }
    }
`;

const order = `
    query Order ($id: String!) {
        order(id: $id) {
            ...orderFragment
        }
    }
    
    ${orderFragment}
`;

const orders = `
    query Orders ($pageLimit: OrdersPagingLimitInput, $pageOffset: OrdersPagingOffsetInput = 0) {
        orders(paging: {limit: $pageLimit, offset: $pageOffset}, sort: sessionDate) {
            items {
                ...orderFragment
            }
        }
    }
    
    ${orderFragment}
`;

const favoriteEvents = `
    query FavoriteEvents ($pageLimit: PagingLimitInput!, $pageOffset: PagingOffsetInput = 0) {
        favoriteEvents(paging: {limit: $pageLimit, offset: $pageOffset}, onlyFuture: true) {
            items {
                ...favoriteEventFragment
            }
        }
    }
    
    ${favoriteEventFragment}
`;

module.exports = {order, orders, favoriteEvents};
